

<?php $__env->startSection('title', $painting->title); ?>

<?php $__env->startSection('content'); ?>

<div class="container py-5">

    <div class="row g-5 align-items-start justify-content-center">

        
        <div class="col-lg-6 text-center">
            <img src="<?php echo e(asset('uploads/paintings/'.$painting->image)); ?>"
                 class="img-fluid rounded shadow-sm"
                 alt="<?php echo e($painting->title); ?>">
        </div>

        
        <div class="col-lg-5">

            
            <h3 class="fw-bold mb-1">
                <?php echo e($painting->painting_code ? $painting->painting_code.': ' : ''); ?>

                <?php echo e($painting->title); ?>

            </h3>
<br>
            
            <?php if($painting->artist): ?>
                <a href="<?php echo e(route('artist.detail', $painting->artist->slug)); ?>"
                   class="text-decoration-none text-dark">
                    <div class="d-flex align-items-center gap-2 mb-3">
                        <img src="<?php echo e($painting->artist->profile_image
                            ? asset('uploads/artists/'.$painting->artist->profile_image)
                            : asset('images/user-placeholder.png')); ?>"
                             class="rounded-circle"
                             style="width:40px;height:40px;object-fit:cover;">
                        <strong class="artist-name">
                            <?php echo e($painting->artist->name); ?>

                        </strong>
                    </div>
                </a>
            <?php endif; ?>

            
            <div class="mb-3">
                <?php if($painting->price_on_request): ?>
                    <div class="d-flex align-items-center gap-3">
                        <span class="price-box price-request">
                            Price on Request
                        </span>

                       
                    </div>
                <?php else: ?>
                    <div class="price-box price-value">
                        &#8377; <?php echo e(number_format((int) $painting->price)); ?>

                        <small class="text-muted">(+ GST)</small>
                    </div>
                <?php endif; ?>
            </div>

            
            <p class="text-muted">
                <?php echo strip_tags($painting->description); ?>

            </p>

        
<?php if($painting->height && $painting->width): ?>
    <div class="mb-2">
        <strong>Size (H×W)</strong> →
        <?php echo e((int) $painting->height); ?>×<?php echo e((int) $painting->width); ?> Inches
    </div>
<?php endif; ?>


            
            <div class="mb-3">
                <strong>Form</strong> → <?php echo e($painting->form->name ?? '—'); ?>

                <span class="mx-2">|</span>
                <strong>Medium</strong> → <?php echo e($painting->medium->name ?? '—'); ?>

            </div>

          
<?php if($painting->categories->count()): ?>
    <div class="mb-3">
        <strong>Themes</strong>

        <div class="d-flex flex-wrap gap-2 mt-2">
            <?php $__currentLoopData = $painting->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <span class="badge bg-light text-dark px-3 py-2 theme-badge">
                    <?php echo e($cat->name); ?>

                </span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php endif; ?>


            
            <div class="artwork-actions mt-4">

                <button class="btn btn-outline-secondary w-100 mb-2"
                        data-bs-toggle="modal"
                        data-bs-target="#priceRequestModal">
                    ✉ Email About This Artwork
                </button>

                <a href="tel:+919999999999"
                   class="btn btn-outline-success w-100 mb-2">
                    📞 Call About This Artwork
                </a>

                <button class="btn btn-outline-secondary w-100"
                        onclick="navigator.share
                            ? navigator.share({
                                title: '<?php echo e($painting->title); ?>',
                                url: window.location.href
                            })
                            : alert('Sharing not supported')">
                    🔗 Share This Artwork
                </button>

            </div>

        </div>
    </div>
</div>


<div class="modal fade" id="priceRequestModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
     <form id="artworkEnquiryForm" class="modal-content">
    <?php echo csrf_field(); ?>

    <div class="modal-header">
        <h5 class="modal-title">Artwork Price Enquiry</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
    </div>

   <div class="modal-body">

    
    <div id="enquirySuccess"
         class="alert alert-success d-none text-center mb-3">
    </div>

    
    <input type="text"
           name="name"
           class="form-control mb-3"
           placeholder="Your Name"
           required>

    
    <input type="email"
           name="email"
           class="form-control mb-3"
           placeholder="Your Email"
           required>

    
    <input type="text"
           name="phone"
           class="form-control mb-3"
           placeholder="Phone Number (Optional)">

    
    <textarea name="message"
              class="form-control mb-3"
              rows="4"
              placeholder="Message about this artwork"
              required></textarea>

    
    <input type="hidden" name="painting_code" value="<?php echo e($painting->painting_code); ?>">
    <input type="hidden" name="painting_title" value="<?php echo e($painting->title); ?>">

    <small class="text-muted">
        We will contact you regarding this artwork.
    </small>
</div>


    <div class="modal-footer">
        <button type="submit" class="btn btn-dark w-100">
            Send Enquiry
        </button>
    </div>
</form>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

<script>
document.addEventListener('DOMContentLoaded', function () {

    const form = document.getElementById('artworkEnquiryForm');
    const successBox = document.getElementById('enquirySuccess');
    const modalEl = document.getElementById('priceRequestModal');

    if (!form) return;

    form.addEventListener('submit', function (e) {
        e.preventDefault();

        const formData = new FormData(form);

        fetch("<?php echo e(route('artwork.enquiry.store')); ?>", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': form.querySelector('input[name=_token]').value,
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: formData
        })
        .then(res => res.json())
        .then(data => {

            if (data.success) {

                // show success
                successBox.innerText = data.message;
                successBox.classList.remove('d-none');

                // reset form
                form.reset();

                // close modal after 2 sec
                setTimeout(() => {
                    const modal = bootstrap.Modal.getOrCreateInstance(modalEl);
                    modal.hide();

                    successBox.classList.add('d-none');
                }, 2000);
            }
        })
        .catch(() => {
            alert('Something went wrong. Please try again.');
        });
    });

});
</script>

<?php $__env->stopPush(); ?>


<style>

    /* ================= ARTWORK ACTION BUTTONS HOVER FIX ================= */

.artwork-actions .btn {
    transition: all 0.3s ease;
}

/* SAME HOVER FOR ALL 3 BUTTONS */
.artwork-actions .btn:hover {
    background-color: #8fa9a0;   /* 👈 your brand green */
    border-color: #8fa9a0;
    color: #fff;
}
.badge.theme-badge {
    font-weight: 400 !important;   /* force normal */
    font-size: 13px;               /* same size */
    font-family: inherit;          /* normal font */
}

.theme-badge {
    font-size: 13px;          /* keep same size */
    font-weight: 400;         /* 👈 NORMAL font */
    background: #f6f6f6;      /* keep same */
    border: 1px solid #e2e2e2;/* keep same */
    font-family: inherit;     /* normal page font */
}


.artist-name:hover{
    text-decoration: underline;
    color:#c62828;
}

.price-box{
    font-size:26px;
    font-weight:700;
}

.price-value{
    color:#148c2e;
}

.price-request{
    color:#c62828;
}

.artwork-actions .btn{
    border-radius:8px;
}

.badge{
    font-size:13px;
    border-radius:20px;
}
</style>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\gallery\resources\views/front/paintings/show.blade.php ENDPATH**/ ?>