@include('layouts.header')


<style>
/* Banner */
.painting-banner {
    background: #f5e9d8;
    padding: 30px;      /* increased from 25px */
    border-radius: 12px;
    display: flex;
    align-items: center;
    gap: 30px;
    
}


.painting-banner img {
    width: 250px;
    height: 250px;
    object-fit: contain;
    border-radius: 50%;
    padding: 6px;
    background: #fff;
}



.painting-banner h2 {
    margin: 0;
    font-size: 30px;
    font-weight: 700;
}

.painting-banner p {
    margin: 5px 0;
    color: #555;
}

/* Grid Layout */
.painting-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 25px;
}

/* Card */
.painting-card {
    background: white;
    padding: 15px;
    border-radius: 12px;
    box-shadow: 0px 4px 18px rgba(0,0,0,0.09);
    transition: .3s;
}

.painting-card:hover {
    transform: translateY(-6px);
}

/* Image style */
.painting-card img {
    width: 100%;
    height: 280px;
    object-fit: cover;
    border-radius: 10px;
}

/* Text */
.painting-card h4 {
    margin-top: 10px;
    font-size: 18px;
    font-weight: 600;
}

.painting-card p {
    margin: 3px 0;
    font-size: 14px;
}

.price {
    font-weight: 600;
    margin-top: 5px;
}

/* Sold Badge */
.sold-badge {
    position: absolute;
    background: #000;
    color: #fff;
    padding: 4px 10px;
    font-size: 13px;
    border-radius: 6px;
    top: 10px;
    right: 10px;
}
.card-image-wrapper {
    position: relative;
}

.painting-banner {
    background: #f5e9d8;
    padding: 20px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    gap: 10px;
}

</style>

<div class="container" style=" padding-bottom:50px;">

    <!-- Banner -->
    <div class="painting-banner">
        
        <img src="uploads/painting1.webp" alt="" style="margin-left:33px;">
        
        <div style="flex:1; margin:40px;">
            <h2>Paintings</h2>
            <p>Shop Exquisite Acrylic & Oil Paintings – Handmade Artwork Online</p>

            <a id="readMoreBtn" style="font-weight:bold; cursor:pointer;">READ MORE →</a>

            <!-- Hidden content INSIDE this block -->
            <div id="moreContent" style="display:none; margin-top:10px; font-size:15px; line-height:1.6;">
                <p>🎨Our handpicked collection brings together the finest Indian contemporary art, bold modern abstractions, serene nature landscapes, and spiritually inspired devotional works. Every piece is crafted by skilled artists using high-quality acrylic and oil mediums, giving each artwork depth, texture, and life. Perfect for living rooms, bedroom interiors, commercial environments, restaurants, and luxury hospitality spaces, our paintings are designed not just to decorate walls — but to create meaningful visual stories that elevate the atmosphere around them.</p>
            </div>
        </div>

    </div>
</div>


    <!-- Painting Grid -->
    <div class="painting-grid" style="margin-left:70px; margin-right:70px; padding-bottom:40px;">

        <!-- Painting Card (Duplicate this to add more items) -->
        <div class="painting-card">
            <div class="card-image-wrapper">
                <span class="sold-badge">SOLD</span> <!-- Remove if available -->
                <img src="https://artazzle.com/cdn/shop/files/Ramesh_Gorjala_Painting_Radha_Krishna.jpg?v=1742956193&width=1200" alt="">
            </div>
            <h4>Waterlilies XVII</h4>
            <p>Artist: Sunil Kale</p>
            <p>Size: 30×36 inches</p>
            <p class="price">Rs. 125,000.00</p>
        </div>

        <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/bright-interior-with-old-bench-seat_1.jpg?v=1744377227&width=1200" alt="">
            <h4>Waterlilies XVI</h4>
            <p>Artist: Sunil Kale</p>
            <p>Size: 30×36 inches</p>
            <p class="price">Rs. 125,000.00</p>
        </div>

        <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/RameshGajendraPC732.jpg?v=1721018514&width=1200" alt="">
            <h4>Banaras I</h4>
            <p>Artist: Amit Bhar</p>
            <p>Size: 36×48 inches</p>
            <p class="price">Rs. 225,000.00</p>
        </div>
          <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/PHOTO-2024-04-13-13-43-28.jpg?v=1713029887&width=1200" alt="">
            <h4>Waterlilies XVI</h4>
            <p>Artist: Sunil Kale</p>
            <p>Size: 30×36 inches</p>
            <p class="price">Rs. 125,000.00</p>
        </div>

        <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/Kamadhenu_Ramesh_Gorjala.jpg?v=1744375223&width=1200" alt="">
            <h4>Banaras I</h4>
            <p>Artist: Amit Bhar</p>
            <p>Size: 36×48 inches</p>
            <p class="price">Rs. 225,000.00</p>
        </div>
          <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/IMG_1857.jpg?v=1716258937&width=1200" alt="">
            <h4>Waterlilies XVI</h4>
            <p>Artist: Sunil Kale</p>
            <p>Size: 30×36 inches</p>
            <p class="price">Rs. 125,000.00</p>
        </div>

        <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/IMG_1725.jpg?v=1713031838&width=1200" alt="">
            <h4>Banaras I</h4>
            <p>Artist: Amit Bhar</p>
            <p>Size: 36×48 inches</p>
            <p class="price">Rs. 225,000.00</p>
        </div>
          <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/PHOTO-2024-07-09-14-50-39.jpg?v=1721017135&width=1200" alt="">
            <h4>Waterlilies XVI</h4>
            <p>Artist: Sunil Kale</p>
            <p>Size: 30×36 inches</p>
            <p class="price">Rs. 125,000.00</p>
        </div>

        <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/IMG_1857.jpg?v=1716258937&width=1200" alt="">
            <h4>Banaras I</h4>
            <p>Artist: Amit Bhar</p>
            <p>Size: 36×48 inches</p>
            <p class="price">Rs. 225,000.00</p>
        </div>
          <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/IMG_1725.jpg?v=1713031838&width=1200" alt="">
            <h4>Waterlilies XVI</h4>
            <p>Artist: Sunil Kale</p>
            <p>Size: 30×36 inches</p>
            <p class="price">Rs. 125,000.00</p>
        </div>

        <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/RameshPC829GajendraII.jpg?v=1721018609&width=1200" alt="">
            <h4>Banaras I</h4>
            <p>Artist: Amit Bhar</p>
            <p>Size: 36×48 inches</p>
            <p class="price">Rs. 225,000.00</p>
        </div>
          <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/RameshPC825.jpg?v=1721016158&width=1200" alt="">
            <h4>Waterlilies XVI</h4>
            <p>Artist: Sunil Kale</p>
            <p>Size: 30×36 inches</p>
            <p class="price">Rs. 125,000.00</p>
        </div>

        <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/RameshPC824.jpg?v=1721015928&width=1200" alt="">
            <h4>Banaras I</h4>
            <p>Artist: Amit Bhar</p>
            <p>Size: 36×48 inches</p>
            <p class="price">Rs. 225,000.00</p>
        </div>
          <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/PHOTO-2024-07-07-14-27-49.jpg?v=1721015240&width=1200" alt="">
            <h4>Waterlilies XVI</h4>
            <p>Artist: Sunil Kale</p>
            <p>Size: 30×36 inches</p>
            <p class="price">Rs. 125,000.00</p>
        </div>

        <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/RameshPC642.jpg?v=1706587120&width=1200" alt="">
            <h4>Banaras I</h4>
            <p>Artist: Amit Bhar</p>
            <p>Size: 36×48 inches</p>
            <p class="price">Rs. 225,000.00</p>
        </div>

          <div class="painting-card">
            <img src="https://artazzle.com/cdn/shop/files/PHOTO-2024-04-10-15-07-05.jpg?v=1713031208&width=1200" alt="">
            <h4>Waterlilies XVI</h4>
            <p>Artist: Sunil Kale</p>
            <p>Size: 30×36 inches</p>
            <p class="price">Rs. 125,000.00</p>
        </div>

        

        <!-- Just copy/paste this block for more paintings -->

    </div>
</div>

<script>
document.getElementById("readMoreBtn").addEventListener("click", function(event) {
    event.preventDefault();

    const content = document.getElementById("moreContent");

    if (content.style.display === "none") {
        content.style.display = "block";
        this.textContent = "SHOW LESS ↑";
    } else {
        content.style.display = "none";
        this.textContent = "READ MORE →";
    }
});
</script>


@include('layouts.footer')