@extends('layouts.app')

@section('title',$sculpture->title)

@section('content')
<div class="container py-5" style="margin-top:40px;">

    <!-- 🔙 Back Button (Top) -->
    <div class="mb-3">
        <a href="/sculptures" class="btn btn-outline-dark btn-sm">
            ← Back to Sculptures
        </a>
    </div>

    <div class="row g-4">
        <div class="col-md-6">
            <img src="{{ asset('uploads/sculptures/'.$sculpture->image) }}"
                 class="img-fluid rounded shadow">
        </div>

        <div class="col-md-6">
            <h2>{{ $sculpture->title }}</h2>

            <h4 class="text-success mt-2">
                ₹ {{ number_format($sculpture->price,2) }}
            </h4>

            <p class="mt-3 text-muted">
                {{ $sculpture->description }}
            </p>

            <!-- 🛒 Buy Now Button -->
            <a href="/contact"
               class="btn btn-warning btn-lg mt-3">
                Buy Now →
            </a>
        </div>
    </div>

</div>
@endsection
