@extends('layouts.app')

@section('title', $painting->title)

@section('content')

<div class="container py-5">

    <div class="row g-5 align-items-start justify-content-center">

        {{-- LEFT IMAGE --}}
        <div class="col-lg-6 text-center">
            <img src="{{ asset('uploads/paintings/'.$painting->image) }}"
                 class="img-fluid rounded shadow-sm"
                 alt="{{ $painting->title }}">
        </div>

        {{-- RIGHT DETAILS --}}
        <div class="col-lg-5">

            {{-- TITLE --}}
            <h3 class="fw-bold mb-1">
                {{ $painting->painting_code ? $painting->painting_code.': ' : '' }}
                {{ $painting->title }}
            </h3>
<br>
            {{-- ARTIST --}}
            @if($painting->artist)
                <a href="{{ route('artist.detail', $painting->artist->slug) }}"
                   class="text-decoration-none text-dark">
                    <div class="d-flex align-items-center gap-2 mb-3">
                        <img src="{{ $painting->artist->profile_image
                            ? asset('uploads/artists/'.$painting->artist->profile_image)
                            : asset('images/user-placeholder.png') }}"
                             class="rounded-circle"
                             style="width:40px;height:40px;object-fit:cover;">
                        <strong class="artist-name">
                            {{ $painting->artist->name }}
                        </strong>
                    </div>
                </a>
            @endif

            {{-- PRICE --}}
            <div class="mb-3">
                @if($painting->price_on_request)
                    <div class="d-flex align-items-center gap-3">
                        <span class="price-box price-request">
                            Price on Request
                        </span>

                       
                    </div>
                @else
                    <div class="price-box price-value">
                        &#8377; {{ number_format((int) $painting->price) }}
                        <small class="text-muted">(+ GST)</small>
                    </div>
                @endif
            </div>

            {{-- DESCRIPTION --}}
            <p class="text-muted">
                {!! strip_tags($painting->description) !!}
            </p>

        {{-- SIZE --}}
@if($painting->height && $painting->width)
    <div class="mb-2">
        <strong>Size (H×W)</strong> →
        {{ (int) $painting->height }}×{{ (int) $painting->width }} Inches
    </div>
@endif


            {{-- FORM + MEDIUM --}}
            <div class="mb-3">
                <strong>Form</strong> → {{ $painting->form->name ?? '—' }}
                <span class="mx-2">|</span>
                <strong>Medium</strong> → {{ $painting->medium->name ?? '—' }}
            </div>

          {{-- THEMES --}}
@if($painting->categories->count())
    <div class="mb-3">
        <strong>Themes</strong>

        <div class="d-flex flex-wrap gap-2 mt-2">
            @foreach($painting->categories as $cat)
                <span class="badge bg-light text-dark px-3 py-2 theme-badge">
                    {{ $cat->name }}
                </span>
            @endforeach
        </div>
    </div>
@endif


            {{-- ACTION BUTTONS (COLUMN WISE) --}}
            <div class="artwork-actions mt-4">

                <button class="btn btn-outline-secondary w-100 mb-2"
                        data-bs-toggle="modal"
                        data-bs-target="#priceRequestModal">
                    ✉ Email About This Artwork
                </button>

                <a href="tel:+919999999999"
                   class="btn btn-outline-success w-100 mb-2">
                    📞 Call About This Artwork
                </a>

                <button class="btn btn-outline-secondary w-100"
                        onclick="navigator.share
                            ? navigator.share({
                                title: '{{ $painting->title }}',
                                url: window.location.href
                            })
                            : alert('Sharing not supported')">
                    🔗 Share This Artwork
                </button>

            </div>

        </div>
    </div>
</div>

{{-- ================= EMAIL MODAL ================= --}}
<div class="modal fade" id="priceRequestModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
     <form id="artworkEnquiryForm" class="modal-content">
    @csrf

    <div class="modal-header">
        <h5 class="modal-title">Artwork Price Enquiry</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
    </div>

   <div class="modal-body">

    {{-- SUCCESS MESSAGE --}}
    <div id="enquirySuccess"
         class="alert alert-success d-none text-center mb-3">
    </div>

    {{-- NAME --}}
    <input type="text"
           name="name"
           class="form-control mb-3"
           placeholder="Your Name"
           required>

    {{-- EMAIL --}}
    <input type="email"
           name="email"
           class="form-control mb-3"
           placeholder="Your Email"
           required>

    {{-- PHONE (OPTIONAL) --}}
    <input type="text"
           name="phone"
           class="form-control mb-3"
           placeholder="Phone Number (Optional)">

    {{-- MESSAGE --}}
    <textarea name="message"
              class="form-control mb-3"
              rows="4"
              placeholder="Message about this artwork"
              required></textarea>

    {{-- REQUIRED BY CONTROLLER --}}
    <input type="hidden" name="painting_code" value="{{ $painting->painting_code }}">
    <input type="hidden" name="painting_title" value="{{ $painting->title }}">

    <small class="text-muted">
        We will contact you regarding this artwork.
    </small>
</div>


    <div class="modal-footer">
        <button type="submit" class="btn btn-dark w-100">
            Send Enquiry
        </button>
    </div>
</form>

    </div>
</div>

@endsection

@push('scripts')

<script>
document.addEventListener('DOMContentLoaded', function () {

    const form = document.getElementById('artworkEnquiryForm');
    const successBox = document.getElementById('enquirySuccess');
    const modalEl = document.getElementById('priceRequestModal');

    if (!form) return;

    form.addEventListener('submit', function (e) {
        e.preventDefault();

        const formData = new FormData(form);

        fetch("{{ route('artwork.enquiry.store') }}", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': form.querySelector('input[name=_token]').value,
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: formData
        })
        .then(res => res.json())
        .then(data => {

            if (data.success) {

                // show success
                successBox.innerText = data.message;
                successBox.classList.remove('d-none');

                // reset form
                form.reset();

                // close modal after 2 sec
                setTimeout(() => {
                    const modal = bootstrap.Modal.getOrCreateInstance(modalEl);
                    modal.hide();

                    successBox.classList.add('d-none');
                }, 2000);
            }
        })
        .catch(() => {
            alert('Something went wrong. Please try again.');
        });
    });

});
</script>

@endpush

{{-- ================= STYLES ================= --}}
<style>

    /* ================= ARTWORK ACTION BUTTONS HOVER FIX ================= */

.artwork-actions .btn {
    transition: all 0.3s ease;
}

/* SAME HOVER FOR ALL 3 BUTTONS */
.artwork-actions .btn:hover {
    background-color: #8fa9a0;   /* 👈 your brand green */
    border-color: #8fa9a0;
    color: #fff;
}
.badge.theme-badge {
    font-weight: 400 !important;   /* force normal */
    font-size: 13px;               /* same size */
    font-family: inherit;          /* normal font */
}

.theme-badge {
    font-size: 13px;          /* keep same size */
    font-weight: 400;         /* 👈 NORMAL font */
    background: #f6f6f6;      /* keep same */
    border: 1px solid #e2e2e2;/* keep same */
    font-family: inherit;     /* normal page font */
}


.artist-name:hover{
    text-decoration: underline;
    color:#c62828;
}

.price-box{
    font-size:26px;
    font-weight:700;
}

.price-value{
    color:#148c2e;
}

.price-request{
    color:#c62828;
}

.artwork-actions .btn{
    border-radius:8px;
}

.badge{
    font-size:13px;
    border-radius:20px;
}
</style>
