<div class="row g-4">

@forelse($paintings as $painting)
    <div class="col-6 col-sm-6 col-md-4 col-lg-3 col-xl-3">


        {{-- FULL CARD CLICKABLE --}}
        <a href="{{ route('artworks.show', $painting->slug) }}"
           class="text-decoration-none text-dark">

            <div class="painting-card shadow-sm h-100">

                {{-- IMAGE --}}
                <div class="painting-image">
                    <img src="{{ asset('uploads/paintings/'.$painting->image) }}"
                         alt="{{ $painting->title }}">
                </div>

                {{-- CONTENT --}}
                <div class="painting-body text-center">

                    {{-- TITLE : CODE + NAME --}}
                    <h6 class="mb-1 fw-semibold">
                        {{ $painting->painting_code
                            ? $painting->painting_code.' : '
                            : '' }}
                        {{ \Illuminate\Support\Str::limit($painting->title, 20) }}
                    </h6>

                    {{-- ARTIST --}}
                    <p class="text-muted small mb-1">
                        {{ $painting->artist->name ?? 'Unknown Artist' }}
                    </p>

                    @if($painting->width && $painting->height)
    <p class="text-muted small mb-1 painting-size">
        
        {{ rtrim(rtrim(number_format($painting->width, 2, '.', ''), '0'), '.') }}×{{ rtrim(rtrim(number_format($painting->height, 2, '.', ''), '0'), '.') }}
        
    </p>
@endif


                    {{-- PRICE --}}
                    <p class="price fw-bold mb-0">
                        @if($painting->price_on_request)
                            <span class="text-danger">Price on Request</span>
                        @elseif(!is_null($painting->price))
                            <span class="text-success">&#8377; {{ number_format((int) $painting->price) }}</span>

                        @else
                            <span class="text-muted">—</span>
                        @endif
                    </p>

                </div>
            </div>

        </a>
    </div>
@empty
    <div class="col-12">
        <p class="text-center text-muted">
            No Artworks Found.
        </p>
    </div>
@endforelse

</div>

{{-- PAGINATION --}}
@if($paintings->hasPages())
<div class="mt-4">
    {{ $paintings->links() }}
</div>
@endif
