@extends('layouts.app')


@section('title','Home')

@php
  // sample fallbacks if collections not passed
  $artists = $artists ?? \App\Models\Artist::latest()->take(8)->get();
  $categories = $categories ?? \App\Models\Category::all()->take(4);
  $events = $events ?? \App\Models\Event::latest()->take(4)->get();
@endphp

@section('content')
<main>

{{-- ================= HERO SECTION ================= --}}
<section class="hero-section">


<div id="heroCarousel"
     class="carousel slide"
     data-bs-ride="carousel"
     data-bs-interval="6000">

    <div class="carousel-inner">

        @foreach($heroSlides as $key => $slide)
        <div class="carousel-item {{ $key == 0 ? 'active' : '' }}">

            {{-- FULL WIDTH IMAGE --}}
            <img
                src="{{ asset('uploads/hero/'.$slide->image) }}"
                class="hero-image hero-zoom"
                alt="{{ $slide->title }}"
            >

            {{-- ALIGNED CONTENT --}}
            <div class="hero-content">
                <div class="site-inner">

                    <div class="hero-frame">

                        <h1>{{ $slide->title }}</h1>

                        @if($slide->subtitle)
                            <p>{{ $slide->subtitle }}</p>
                        @endif

                        @if($slide->button_text && $slide->button_link)
                            <a href="{{ $slide->button_link }}"
                               class="btn btn-dark-pill">
                                {{ $slide->button_text }} →
                            </a>
                        @endif

                    </div>

                </div>
            </div>

        </div>
        @endforeach

    </div>

</div>
</section>

<style>
    /* ================= HERO CONTENT SLIDE IN ================= */

/* initial hidden state */
.hero-frame {
    opacity: 0;
    transform: translateX(-60px);
}

/* when slide is active */
.carousel-item.active .hero-frame {
    animation: heroSlideIn 1s ease-out forwards;
}

/* animation keyframes */
@keyframes heroSlideIn {
    from {
        opacity: 0;
        transform: translateX(-60px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

  /* ================= HERO SECTION ================= */

.hero-section {
    position: relative;
    width: 100%;
}

/* SLIDE */
.hero-section .carousel-item {
    position: relative;
    height: 600px;
    overflow: hidden;
}

/* IMAGE FULL WIDTH */
.hero-image {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ZOOM EFFECT (SAME AS BEFORE) */
.hero-zoom {
    animation: heroZoomIn 10s ease-in-out forwards;
    transform-origin: center center;
}

@keyframes heroZoomIn {
    from { transform: scale(1); }
    to   { transform: scale(1.15); }
}

/* CONTENT OVERLAY */
.hero-content {
    position: absolute;
    inset: 0;
    display: flex;
    align-items: center;   /* vertical center */
}

/* HERO FRAME (UNCHANGED LOOK) */
.hero-frame {
    background: #0000004a;
    backdrop-filter: blur(1px);
    -webkit-backdrop-filter: blur(1px);

    padding: 28px 34px;
    border-radius: 18px;
    max-width: 713px;

    box-shadow: 0 20px 45px rgba(0,0,0,0.15);
    border: 1px solid rgba(255,255,255,0.4);
}

/* TEXT */
.hero-frame h1 {
    font-size: 2rem;
    font-weight: 500;
    margin-bottom: 12px;
    line-height: 1.2;
    color: #fff;
}

.hero-frame p {
    font-size: 1.05rem;
    line-height: 1.6;
    margin-bottom: 22px;
    color: #fff;
}

/* BUTTON */
.btn-dark-pill {
    background-color: #8fa9a0;
    color: #fff;
    border-radius: 50rem;
    padding: 10px 22px;
    font-weight: 500;
    text-decoration: none;
}

.btn-dark-pill:hover {
    background-color: #819A91; /* same as normal */
    transform: none;           /* ❌ no movement */
}


/* MOBILE */
@media (max-width: 768px) {

    .hero-section .carousel-item {
        height: 480px;
    }

    .hero-frame {
        padding: 22px 24px;
        max-width: 100%;
    }

    .hero-frame h1 {
        font-size: 1.8rem;
    }
}
</style>

{{-- ================= MEET OUR ARTISTS ================= --}}
<section class="meet-artists-section">
    <div class="site-inner">

        <div class="text-center mb-5">
            <h2 class="section-title">Meet Our Featured Artists</h2>
            <p class="section-subtitle">
                Discover from a curated collection of artworks by renowned Indian Artists
            </p>
        </div>

        @if(isset($featuredArtists) && $featuredArtists->count())
         <div class="artists-slider-wrapper">
    <div class="row artists-slider">


                @foreach($featuredArtists as $artist)
                    <div class="col-artist">

                        <a href="{{ route('artist.detail', $artist->slug) }}"
                           style="text-decoration:none;color:inherit;">

                            <div class="artist-card">

                                <div class="artist-artwork-frame">
                                    <img
                                        src="{{ asset('uploads/artists/'.$artist->artwork_image) }}"
                                        alt="{{ $artist->name }}"
                                        class="artist-artwork"
                                    >
                                </div>

                                <div class="artist-avatar">
                                    <img
                                        src="{{ asset('uploads/artists/'.$artist->profile_image) }}"
                                        alt="{{ $artist->name }}"
                                    >
                                </div>

                                <p class="artist-name">{{ $artist->name }}</p>

                            </div>
                        </a>

                    </div>
                @endforeach

            </div>
</div>
            <div class="text-center mt-5">
                <a href="{{ \App\Models\SeoPage::url('artists', '/artists') }}" class="view-all-btn">
                    View All Artists →
                </a>
            </div>
        @else
            <p class="text-center text-muted">
                No featured artists available at the moment.
            </p>
        @endif

    </div>
</section>







<style>
 /* FIX BOOTSTRAP ROW OFFSET INSIDE SITE-INNER */
.meet-artists-section .row {
    margin-left: 0;
    margin-right: 0;
}


/* ================= MEET OUR ARTISTS ================= */
/* ================= 5 ITEMS PER ROW ================= */

.col-artist {
    width: 20%;
    padding: 12px;
}

/* Tablet */
@media (max-width: 1200px) {
    .col-artist {
        width: 25%; /* 4 per row */
    }
}

/* Small tablet */
@media (max-width: 992px) {
    .col-artist {
        width: 33.33%; /* 3 per row */
    }
}

/* Mobile */
@media (max-width: 576px) {
    .col-artist {
        width: 50%; /* 2 per row */
    }
}

.meet-artists-section {
    padding-top: 55px;   /* 👈 hero se gap */
    padding-bottom: 15px;
    background: #ffffff;
}


.section-title {
    font-size: 28px;
    font-weight: 600;
    margin-bottom: 6px;
}

.section-subtitle {
    font-size: 14px;
    color: #6f6f6f;
    
}
.meet-artists-section .section-title {
    margin-bottom: 12px;   /* 👈 heading → subtitle gap */
}

.meet-artists-section .section-subtitle {
    margin-top: 0;        /* 👈 default p margin हटाया */
}
.meet-artists-section .text-center {
    margin-bottom: 42px !important;
}

/* ================= CARD ================= */

.artist-card {
    background: #ffffff;
    border-radius: 14px;
    text-align: center;
    padding-bottom: 1px;
    box-shadow: 0 10px 26px rgba(0,0,0,0.12);
    position: relative;
}

/* ================= ARTWORK FRAME ================= */

.artist-artwork-frame {
    background: #d9d9d9;
    padding: 10px;
    border-radius: 14px 14px 0 0;
}

.artist-artwork {
    width: 100%;
    height: 220px;
    object-fit: cover;
    border-radius: 10px;
    display: block;
}

/* ================= AVATAR ================= */

.artist-avatar {
    position: absolute;
    left: 50%;
    bottom: 49px;
    transform: translateX(-50%);
    background: #ffffff;
    padding: 6px;
    border-radius: 50%;
}

.artist-avatar img {
    width: 80px;
    height: 80px;
    object-fit: cover;
    border-radius: 50%;
    display: block;
}

/* ================= NAME ================= */


.artist-name {
    margin-top: 60px;
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.4px;
    color: #000;
}

/* ================= VIEW ALL ================= */

.view-all-btn {
    display: inline-block;
    padding: 8px 26px;
    background: #8fa9a0;
    color: #fff;
    border-radius: 30px;
    font-size: 14px;
    text-decoration: none;
}

.view-all-btn:hover {
    background: #6e867e;
    color: #fff;
}

/* ================= RESPONSIVE ================= */

@media (max-width: 768px) {
    .artist-artwork {
        height: 105px;
    }

    .artist-avatar img {
        width: 56px;
        height: 56px;
    }

    .artist-name {
        margin-top: 54px;
    }
}
@media (max-width: 576px) {

.artist-artwork-frame{
    padding:7px;
}

    .artists-slider-wrapper {
        overflow: hidden;   /* 🔒 clipping */
        width: 100%;
    }

    .meet-artists-section .row.artists-slider {
        display: flex;
        flex-wrap: nowrap;
        justify-content: flex-start; /* ❌ center हटाया */
        will-change: transform;
    }

    .meet-artists-section .col-artist {
        flex: 0 0 50%;
        max-width: 50%;
    }
}




</style>
<script>
document.addEventListener("DOMContentLoaded", function () {

    if (window.innerWidth > 576) return;

    const row = document.querySelector('.artists-slider');
    if (!row) return;

    let items = Array.from(row.children);
    if (items.length < 3) return;

    function initSlider() {

        const itemWidth = items[0].getBoundingClientRect().width;
        if (itemWidth === 0) {
            requestAnimationFrame(initSlider);
            return;
        }

        let index = 1;

        const firstClone = items[0].cloneNode(true);
        const lastClone  = items[items.length - 1].cloneNode(true);

        row.appendChild(firstClone);
        row.insertBefore(lastClone, items[0]);

        items = Array.from(row.children);

        row.style.transition = 'none';
        row.style.transform = `translateX(-${itemWidth}px)`;

        setInterval(() => {
            index++;
            row.style.transition = 'transform 0.6s ease';
            row.style.transform = `translateX(-${index * itemWidth}px)`;

            if (index === items.length - 1) {
                setTimeout(() => {
                    row.style.transition = 'none';
                    index = 1;
                    row.style.transform = `translateX(-${itemWidth}px)`;
                }, 650);
            }
        }, 3000);
    }

    requestAnimationFrame(initSlider);
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {

    if (window.innerWidth > 576) return;

    const slider = document.querySelector('.artists-slider');
    if (!slider) return;

    let startX = 0;
    let currentX = 0;
    let isDragging = false;

    slider.addEventListener('touchstart', function (e) {
        startX = e.touches[0].clientX;
        isDragging = true;
    }, { passive: true });

    slider.addEventListener('touchmove', function (e) {
        if (!isDragging) return;
        currentX = e.touches[0].clientX;
    }, { passive: true });

    slider.addEventListener('touchend', function () {
        if (!isDragging) return;
        isDragging = false;

        const diff = startX - currentX;

        if (Math.abs(diff) > 50) {
            if (diff > 0) {
                slider.style.transform += ` translateX(-1px)`; // left swipe
            } else {
                slider.style.transform += ` translateX(1px)`;  // right swipe
            }
        }
    });

});
</script>



@if(isset($featuredExhibitions) && $featuredExhibitions->count())
<section class="creativity-exclusive">

    <div class="site-inner">

        <!-- SECTION HEADER -->
        <div class="text-center mb-4">
            <h2>Featured Exclusive</h2>
            <p class="subtext">
                Discover our highlighted Exclusive curated for art lovers
            </p>
        </div>

        <!-- SLIDER -->
        <div class="exclusive-slider">

            @foreach($featuredExhibitions as $index => $exhibition)
            <div class="exclusive-slide {{ $index === 0 ? 'active' : '' }}">

                <div class="exclusive-card">

                    <!-- IMAGE -->
                    <div class="exclusive-image">
                        <img
                            src="{{ asset('storage/'.$exhibition->cover_image) }}"
                            alt="{{ $exhibition->title }}"
                        >
                    </div>

                    <!-- CONTENT -->
                    <div class="exclusive-content">

                        <h3 class="exhibition-title">
                            {{ $exhibition->title }}
                        </h3>

                        @if(!empty($exhibition->venue))
                            <p class="exhibition-venue">
                                📍 {{ $exhibition->venue }}
                            </p>
                        @endif

                        @if($exhibition->start_date || $exhibition->end_date)
                            <p class="exhibition-dates">
                                🗓
                                @if($exhibition->start_date)
                                    {{ \Carbon\Carbon::parse($exhibition->start_date)->format('d M Y') }}
                                @endif

                                @if($exhibition->start_date && $exhibition->end_date)
                                    &nbsp;–&nbsp;
                                @endif

                                @if($exhibition->end_date)
                                    {{ \Carbon\Carbon::parse($exhibition->end_date)->format('d M Y') }}
                                @else
                                    Ongoing
                                @endif
                            </p>
                        @endif

                        @if(!empty($exhibition->description))
                            <p class="exhibition-description">
                                {{ \Str::limit($exhibition->description, 180) }}
                            </p>
                        @endif

                       <a href="{{ route('exhibitions.show', $exhibition->slug) }}"
   class="exclusive-btn">

    <span class="exclusive-content-inline">
        <span class="exclusive-text">View Exclusive</span>
        <span class="exclusive-arrow">→</span>
    </span>

</a>


                    </div>

                </div>

            </div>
            @endforeach

        </div>

    </div>

</section>
@endif




<style>

    /* ================= FEATURED EXCLUSIVE – 16:9 BANNER FIX ================= */

.exclusive-image {
    width: 50%;
    aspect-ratio: 16 / 9;   /* ✅ FORCE 16:9 */
    overflow: hidden;
}

/* IMAGE */
.exclusive-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;      /* ✅ NO STRETCH */
    display: block;
    animation: zoomIn 12s ease-in-out infinite;
}

/* MOBILE */
@media (max-width: 991px) {
    .exclusive-image {
        width: 100%;
        aspect-ratio: 16 / 9;   /* ✅ STILL 16:9 */
    }
}

    /* FIX: prevent bootstrap-like offset inside site-inner */
.creativity-exclusive .exclusive-slider {
    position: relative;
}

    /* DATE RANGE */
.exhibition-dates {
    font-size: 13px;
    font-weight: 500;
    color: #444;
    margin-bottom: 14px;
    display: flex;
    align-items: center;
    gap: 6px;
}

 /* ================= FEATURED EXHIBITIONS ================= */

.creativity-exclusive {
    background: #8fa9a0;
    padding: 70px 0;
}

.creativity-exclusive h2 {
    color: #fff;
    font-weight: 600;
}

.creativity-exclusive .subtext {
    color: rgba(255,255,255,0.85);
    max-width: 520px;
    margin: 0 auto 40px;
    font-size: 15px;
}

/* SLIDER */
.exclusive-slider {
    position: relative;
    min-height: 360px;
}

/* SLIDE */
.exclusive-slide {
    position: absolute;
    inset: 0;
    opacity: 0;
    transition: opacity 0.6s ease;
}

.exclusive-slide.active {
    position: relative;
    opacity: 1;
}

/* CARD */
.exclusive-card {
    background: #ffffff;
    border-radius: 16px;
    overflow: hidden;
    display: flex;
    box-shadow: 0 20px 50px rgba(0,0,0,0.15);
}

/* IMAGE */
.exclusive-image {
    width: 50%;
}

.exclusive-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    animation: zoomIn 12s ease-in-out infinite;
}

@keyframes zoomIn {
    from { transform: scale(1); }
    to { transform: scale(1.1); }
}

/* CONTENT */
.exclusive-content {
    width: 50%;
    padding: 40px;
}

/* TITLE */
.exhibition-title {
    font-size: 28px;
    font-weight: 600;
    margin-bottom: 8px;
}

/* VENUE */
.exhibition-venue {
    font-size: 14px;
    font-weight: 600;
    color: #6f8f86;
    margin-bottom: 14px;
}

/* DESCRIPTION */
.exhibition-description {
    font-size: 15px;
    color: #555;
    line-height: 1.6;
    margin-bottom: 22px;
}

/* BUTTON */
.exclusive-btn {
    position: relative;
    display: inline-flex;
    align-items: center;
    height: 48px;
    width: 48px;
    background: #6f8f86;
    border-radius: 30px;
    overflow: hidden;
    transition: width 0.4s ease;
    text-decoration: none;
}

/* EXPAND */
.exclusive-btn:hover {
    width: 200px;
}

/* INLINE CONTENT (TEXT + ARROW GROUP) */
.exclusive-content-inline {
    display: inline-flex;
    align-items: center;
    gap: 1px;                /* 👈 arrow text ke paas */
    margin-left: 22px;       /* same visual start as before */
}

/* TEXT */
.exclusive-text {
    color: #fff;
    font-weight: 600;
    font-size: 14px;
    opacity: 0;
    white-space: nowrap;
    transition: opacity 0.3s ease;
}

/* ARROW */
.exclusive-arrow {
    color: #fff;
    font-size: 16px;
}

/* SHOW TEXT ON HOVER */
.exclusive-btn:hover .exclusive-text {
    opacity: 1;
}



/* MOBILE */
@media (max-width: 991px) {
    .exclusive-card {
        flex-direction: column;
    }

    .exclusive-image,
    .exclusive-content {
        width: 100%;
    }

    .exclusive-slider {
        min-height: 520px;
    }
}

</style>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const slides = document.querySelectorAll('.exclusive-slide');
    if (!slides.length) return;

    let index = 0;

    setInterval(() => {
        slides[index].classList.remove('active');
        index = (index + 1) % slides.length;
        slides[index].classList.add('active');
    }, 6000);
});
</script>




 <!-- SHOP BY THEME -->
<section class="py-5 shop-by-theme">
    <div class="site-inner">

        <div class="text-center mb-4">
            <h2>Art by Theme</h2>
        </div>

        <br>

        <div class="medium-slider-wrapper">

            <!-- SLIDER -->
            <div class="medium-slider" id="mediumSlider">

                @foreach($categories as $category)
                <div class="medium-item">

                    <div class="medium-circle">

                        <img
                            src="{{ asset('uploads/categories/' . $category->image) }}"
                            alt="{{ $category->name }}"
                        >

                        <div class="medium-overlay">
                            <span>{{ $category->name }}</span>
                        </div>

                    </div>

                </div>
                @endforeach

            </div>

        </div>

    </div>
</section>

<br>

<style>

    /* PREVENT FLEX SLIDER TOUCHING EDGES */
.shop-by-theme .medium-slider-wrapper {
    width: 100%;
}

    .medium-item {
    cursor: default;
}

.medium-overlay {
    pointer-events: none;
}

    /* IMAGE CONTAINER */
.medium-circle {
    position: relative;              /* 🔥 REQUIRED */
    width: 100%;
    max-width: 200px;
    aspect-ratio: 1 / 1;
    border-radius: 50%;
    overflow: hidden;
    margin: 0 auto;
}

/* IMAGE */
.medium-circle img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.medium-overlay {
    position: absolute;
    inset: 0;

    display: flex;
    align-items: center;
    justify-content: center;

    background: rgba(87, 85, 85, 0.54);   /* 🖤 halka black */
    backdrop-filter: blur(1px);        /* ✨ BLUR EFFECT */
    -webkit-backdrop-filter: blur(4px);

    z-index: 3;
    opacity: 1;
}


.medium-overlay span {
    color: #ffffff;
    font-size: 18px;
    font-weight: 600;
    letter-spacing: 0.8px;
    text-transform: uppercase;

    background: none;
    padding: 0;

    text-shadow: 0 2px 8px rgba(0,0,0,0.7); /* 👌 clarity */
}

.medium-circle img {
    position: relative;
    z-index: 1;
}



/* OPTIONAL: subtle hover polish */
.medium-circle:hover img {
    transform: scale(1.05);
}




  
/* ================= SHOP BY MEDIUM SLIDER ================= */

.medium-slider-wrapper {
    position: relative;
    overflow: hidden;   /* 🔒 HARD CLIP */
    width: 100%;
}

/* Slider */
.medium-slider {
    display: flex;
    transition: transform 0.4s ease;
}

/* EXACT 5 ITEMS */
.medium-item {
    flex: 0 0 20%;     /* ✅ EXACT 5 */
    max-width: 20%;
    text-align: center;
    padding: 0 12px;   /* spacing INSIDE item */
    box-sizing: border-box;
}

/* CIRCLE IMAGE */
.medium-circle {
    width: 100%;
    max-width: 200px;
    aspect-ratio: 1 / 1;
    border-radius: 50%;
    overflow: hidden;
    margin: 0 auto;
}

.medium-circle img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* NAV BUTTONS */
.medium-nav {
    position: absolute;
    top: 45%;
    transform: translateY(-50%);
    background: #fff;
    border: none;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    cursor: pointer;
    font-size: 22px;
    z-index: 10;
}

.medium-nav.left { left: -20px; }
.medium-nav.right { right: -20px; }

/* RESPONSIVE */
@media (max-width: 1200px) {
    .medium-item { flex: 0 0 25%; max-width: 25%; }
}

@media (max-width: 992px) {
    .medium-item { flex: 0 0 33.33%; max-width: 33.33%; }
}

@media (max-width: 576px) {
    .medium-item { flex: 0 0 50%; max-width: 50%; }
}

</style>

<script>
let mediumIndex = 0;

function slideMedium(direction) {
    const slider = document.getElementById('mediumSlider');
    const items = slider.children;
    const visibleItems = 5;

    const itemWidth = items[0].offsetWidth;
    const totalItems = items.length;
    const maxIndex = totalItems - visibleItems;

    mediumIndex += direction;

    if (mediumIndex < 0) mediumIndex = 0;
    if (mediumIndex > maxIndex) mediumIndex = maxIndex;

    slider.style.transform = `translateX(-${mediumIndex * itemWidth}px)`;
}

/* AUTO SLIDE */
setInterval(() => {
    slideMedium(1);
}, 4000);
</script>



@if($aboutCreativity)
<section class="about-creativity-section">

    <div class="site-inner">

        <!-- SECTION HEADING (MOVED ABOVE, NOT DUPLICATED) -->
        <div class="text-center mb-5">
            <h2 class="about-section-title">
                {{ $aboutCreativity->title }}
            </h2>
        </div>

        <div class="row align-items-center g-5">

            <!-- LEFT MEDIA -->
            <div class="col-lg-5">
                <div class="about-media">

                    @if($aboutCreativity->media_type === 'video')
                        <iframe
                            src="{{ $aboutCreativity->media_url }}"
                            frameborder="0"
                            allowfullscreen>
                        </iframe>
                    @else
                        <img
                            src="{{ asset($aboutCreativity->media_url) }}"
                            alt="About Creativity">
                    @endif

                </div>
            </div>

            <!-- RIGHT CONTENT -->
            <div class="col-lg-7">
                <div class="about-content">

                    <p>{{ $aboutCreativity->description_1 }}</p>

                    @if($aboutCreativity->description_2)
                        <p>{{ $aboutCreativity->description_2 }}</p>
                    @endif

                    <a href="{{ $aboutCreativity->button_link }}"
                       class="exclusive-btn mt-3">
                        <span class="exclusive-text">
                            {{ $aboutCreativity->button_text }}
                        </span>
                        <span class="exclusive-arrow">
                            <i class="fa fa-arrow-right"></i>
                        </span>
                    </a>

                </div>
            </div>

        </div>

    </div>

</section>
@endif


<style>
    /* CENTERED SECTION HEADING */
.about-section-title {
    font-size: 34px;
    font-weight: 700;
    color: #ffffff;
    margin-bottom: 0;
}

/* FIX BOOTSTRAP ROW OFFSET INSIDE SITE-INNER */
.about-creativity-section .row {
    margin-left: 0;
    margin-right: 0;
}

  /* SECTION */
.about-creativity-section {
    background: #8fa9a0; /* muted green */
    padding: 30px 0;
}

/* LEFT MEDIA */
/* ================= ABOUT CREATIVITY – 16:9 VIDEO FIX ================= */

.about-media {
    position: relative;
    width: 100%;
    aspect-ratio: 16 / 9;   /* ✅ FORCE 16:9 */
    overflow: hidden;
    border-radius: 16px;
}


.about-media iframe,
.about-media img {
    position: absolute;
    inset: 0;

    width: 100%;
    height: 100%;
    object-fit: cover;   /* ✅ no black bars */
}


/* subtle zoom */
.about-media:hover iframe,
.about-media:hover img {
    transform: scale(1.08);
}

/* RIGHT CONTENT */
.about-content {
    color: #ffffff;
}

.about-content h2 {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 20px;
}

.about-content p {
    font-size: 15px;
    line-height: 1.8;
    margin-bottom: 16px;
    color: #f1f1f1;
}

/* CTA BUTTON (same as before) */
.exclusive-btn {
    position: relative;
    display: inline-flex;
    align-items: center;
    height: 48px;
    width: 48px;
    background: #6f8f86;
    border-radius: 30px;
    text-decoration: none;
    overflow: hidden;
    transition: width 0.45s ease;
}

.exclusive-text {
    position: absolute;
    left: 22px;
    white-space: nowrap;
    color: #fff;
    font-weight: 600;
    font-size: 14px;
    opacity: 0;
    transform: translateX(-10px);
    transition: opacity 0.25s ease, transform 0.35s ease;
}

.exclusive-arrow {
    position: absolute;
    right: 16px;
    color: #fff;
    font-size: 16px;
    transition: transform 0.35s ease;
}

.exclusive-btn:hover {
    width: 160px;
}

.exclusive-btn:hover .exclusive-text {
    opacity: 1;
    transform: translateX(0);
}

.exclusive-btn:hover .exclusive-arrow {
    transform: translateX(4px);
}

/* MOBILE */
@media (max-width: 768px) {
    .about-creativity-section {
        padding: 60px 0;
    }

    .about-media iframe,
    .about-media img {
        height: 240px;
    }

    .exclusive-btn {
        width: 160px;
    }

    .exclusive-text {
        opacity: 1;
        transform: translateX(0);
    }
}

</style>

<style>
 .event-card {
    min-height: 350px;
    border-radius: 10px;
}

.event-img {
    height: 350px;
    width: 100%;
    object-fit: cover;
    border-top-left-radius: 10px;
    border-bottom-left-radius: 10px;
}






</style>

<section class="testimonials-section">
    <div class="site-inner">

        <h2 class="section-title text-center">Client Testimonials</h2>

        <div id="testimonialCarousel"
             class="carousel slide"
             data-bs-ride="carousel">

            <div class="carousel-inner">

                @foreach($testimonials->chunk(3) as $key => $chunk)
                <div class="carousel-item {{ $key == 0 ? 'active' : '' }}">

                    <div class="row justify-content-center">

                        @foreach($chunk as $testimonial)
                        <div class="col-md-4 {{ !$loop->first ? 'd-none d-md-block' : '' }}">

                            <div class="testimonial-card">

                                <p>{{ $testimonial->message }}</p>

                                <div class="testimonial-user">
                                    @if($testimonial->photo)
                                        <img
                                            src="{{ asset('storage/'.$testimonial->photo) }}"
                                            class="avatar"
                                        >
                                    @else
                                        <span class="avatar"></span>
                                    @endif
                                    <strong>{{ $testimonial->name }}</strong>
                                </div>

                            </div>

                        </div>
                        @endforeach

                    </div>

                </div>
                @endforeach

            </div>

            <!-- DOTS -->
            <div class="carousel-indicators testimonial-dots">
                @foreach($testimonials->chunk(3) as $i => $chunk)
                    <button type="button"
                            data-bs-target="#testimonialCarousel"
                            data-bs-slide-to="{{ $i }}"
                            class="{{ $i == 0 ? 'active' : '' }}">
                    </button>
                @endforeach
            </div>

        </div>

    </div>
</section>

<style>
    /* FIX BOOTSTRAP ROW OFFSET INSIDE SITE-INNER */
.testimonials-section .row {
    margin-left: 0;
    margin-right: 0;
}

  /* ================= TESTIMONIAL SECTION ================= */

.testimonials-section {
    padding: 50px 0;
    background: #ffffff;
}

.section-title {
    font-weight: 600;
    margin-bottom: 40px;
}

/* CARD */
.testimonial-card {
    background: #fff;
    border-radius: 16px;
    padding: 30px 24px;
    text-align: center;
    box-shadow: 0 10px 25px rgba(0,0,0,0.08);
    height: 90%;
}

/* TEXT */
.testimonial-card p {
    font-size: 14px;
    color: #444;
    line-height: 1.7;
    margin-bottom: 22px;
}

/* USER */
.testimonial-user {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 8px;
}

/* AVATAR FIX */
.testimonial-user .avatar {
    width: 42px;
    height: 42px;
    border-radius: 50%;
    background: #d1d1d1;
    border: 2px solid #999;
}

/* NAME */
.testimonial-user strong {
    font-size: 14px;
    font-weight: 600;
    color: #222;
}

/* ================= DOTS FIX ================= */

.carousel-indicators.testimonial-dots {
    position: static;
    margin-top: 30px;
    gap: 10px;
}

.carousel-indicators.testimonial-dots button {
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background-color: #c4c4c4;
    border: none;
    opacity: 1;
}

.carousel-indicators.testimonial-dots .active {
    background-color: #2e2724;
}


</style>




@if($mediaPresences->count())
<section class="media-presence-section">
    <div class="site-inner">

        <h2 class="section-title text-center">Media Presence</h2>

        <div class="media-grid">
            @foreach($mediaPresences as $media)
                <div class="media-card">
                    <img
                        src="{{ asset('storage/'.$media->image) }}"
                        alt="{{ $media->title ?? 'Media Logo' }}"
                    >
                </div>
            @endforeach
        </div>

    </div>
</section>
@endif
@if(!empty($pageContents['home']->content))
<section class="seo-content">
    <div class="site-inner">
        {!! $pageContents['home']->content !!}
    </div>
</section>
@endif

<style>
    /* SAFETY: CMS CONTENT SHOULD NEVER TOUCH EDGES */
.seo-content p,
.seo-content ul,
.seo-content ol {
    max-width: 100%;
}

/* OPTIONAL: spacing polish */
.seo-content {
    padding: 50px 0;
}

 /* ================= MEDIA PRESENCE ================= */

.media-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 24px;
    align-items: center;
}

/* ✅ SQUARE CARD */
.media-card {
    background: #f5f5f5;
    border-radius: 12px;
    padding: 20px;

    aspect-ratio: 1 / 1;   /* 🔥 PERFECT SQUARE */
    display: flex;
    align-items: center;
    justify-content: center;

    transition: transform 0.4s ease, box-shadow 0.4s ease;
}

/* ✅ IMAGE PERFECT FIT */
.media-card img {
    max-width: 80%;
    max-height: 80%;
    object-fit: contain;   /* image cut nahi hogi */
    transition: transform 0.4s ease, filter 0.4s ease;
}

/* HOVER */
.media-card:hover {
    transform: translateY(-6px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.12);
}


</style>
</main> 

@endsection



@push('after-header')
<style>
.object-fit-cover { object-fit:cover; }
</style>
@endpush

@push('footer-scripts')
<script>
  // autoplay media carousel horizontally
  (function(){
    const scroller = document.getElementById('mediaCarousel');
    if(!scroller) return;
    let idx = 0;
    const items = scroller.children;
    function auto() {
      idx++;
      if(idx >= items.length) idx = 0;
      scroller.scrollTo({ left: items[idx].offsetLeft, behavior: 'smooth' });
    }
    setInterval(auto, 3500);
  })();

  // small UX: pause video on mouse leave
  document.addEventListener("DOMContentLoaded", function() {
  document.querySelectorAll('#mediaCarousel video').forEach(v=>{
      v.addEventListener('mouseenter', ()=> v.play());
      v.addEventListener('mouseleave', ()=> v.pause());
  });
});

</script>


<script>
document.addEventListener('DOMContentLoaded', function () {

    const carousel = document.getElementById('heroCarousel');

    if (!carousel) return;

    carousel.addEventListener('slide.bs.carousel', function (e) {

        // remove animation before slide changes
        const currentFrame = carousel.querySelector('.carousel-item.active .hero-frame');
        if (currentFrame) {
            currentFrame.style.animation = 'none';
            currentFrame.offsetHeight; // force reflow
        }
    });

    carousel.addEventListener('slid.bs.carousel', function (e) {

        // re-apply animation on new active slide
        const newFrame = carousel.querySelector('.carousel-item.active .hero-frame');
        if (newFrame) {
            newFrame.style.animation = '';
        }
    });

});
</script>


@endpush
