@extends('layouts.app')

@section('title','My Favourites')

@section('content')
<div class="container py-5">
    <h2 class="mb-4">❤️ My Favourite Paintings</h2>

    <div class="row">
        @forelse($favourites as $fav)
        <div class="col-md-3 mb-4">
            <div class="card shadow-sm">
                <img src="{{ asset('uploads/paintings/'.$fav->painting->image) }}"
                     class="card-img-top">

                <div class="card-body text-center">
                    <h6>{{ $fav->painting->title }}</h6>

                    <a href="{{ route('favourite.toggle',$fav->painting->id) }}"
                       class="btn btn-sm btn-danger">
                        Remove ❤️
                    </a>
                </div>
            </div>
        </div>
        @empty
        <p>No favourites added yet.</p>
        @endforelse
    </div>
</div>
@endsection
