@extends('layouts.app')

@section('title', 'Exhibitions')

@section('content')
<section class="static-art-page">

    <!-- ================= TOP SECTION ================= -->
    <div class="container">
        <div class="top-grid">

            <!-- LEFT IMAGE -->
            <div class="top-image">
                <img src="{{ asset('uploads/ex1.webp') }}"
                     alt="Exhibition Artwork">
            </div>

            <!-- RIGHT EVENT INFO -->
            <div class="top-content">

                <h2 class="event-title">
                    Contemporary Art Exhibition 2025
                </h2>

                <p class="event-meta">
                    📍 <strong>Venue:</strong> Haus Khas Village, New Delhi<br>
                    🗓 <strong>Date:</strong> 25 – 30 March 2025<br>
                    ⏰ <strong>Time:</strong> 11:00 AM – 8:00 PM
                </p>

                <p class="event-desc">
                    This exhibition brings together renowned and emerging
                    Indian artists showcasing paintings, sculptures, and
                    mixed media works celebrating modern creativity.
                </p>

            </div>

        </div>
    </div>

    <!-- ================= IMAGE GRID ================= -->
    <div class="container">
        <div class="bottom-grid">

            @php
                $images = [
                    'ex1.webp','ex2.webp','ex3.webp',
                    'ex1.webp','ex2.webp','ex3.webp',
                    'ex1.webp','ex2.webp','ex3.webp',
                    'ex1.webp','ex2.webp','ex3.webp'
                ];
            @endphp

            @foreach($images as $index => $img)
                <img src="{{ asset('uploads/'.$img) }}"
                     class="gallery-image"
                     data-index="{{ $index }}"
                     alt="Exhibition Image">
            @endforeach

        </div>
    </div>

</section>

<!-- ================= LIGHTBOX ================= -->
<div class="lightbox" id="lightbox">
    <span class="close-btn" onclick="closeLightbox()">✕</span>
    <span class="nav prev" onclick="changeSlide(-1)">❮</span>
    <img id="lightbox-img">
    <span class="nav next" onclick="changeSlide(1)">❯</span>
</div>

@endsection


{{-- ================= STYLES ================= --}}
<style>

/* PAGE */
.static-art-page {
    padding: 70px 0;
    background: #fff;
}

/* TOP GRID */
.top-grid {
    display: grid;
    grid-template-columns: 1.3fr 1fr;
    gap: 60px;
    margin-bottom: 70px;
}

.top-image img {
    width: 100%;
    height: 460px;
    object-fit: cover;
    border-radius: 6px;
}

/* EVENT INFO */
.event-title {
    font-size: 30px;
    font-weight: 600;
    margin-bottom: 14px;
}

.event-meta {
    font-size: 15px;
    color: #555;
    line-height: 1.8;
    margin-bottom: 16px;
}

.event-desc {
    font-size: 15px;
    line-height: 1.7;
    color: #666;
}

/* GRID */
.bottom-grid {
    display: grid;
    grid-template-columns: repeat(6, 1fr);
    gap: 26px;
}

.gallery-image {
    width: 100%;
    height: 160px;
    object-fit: cover;
    cursor: pointer;
    border-radius: 4px;
    transition: 0.3s;
}

.gallery-image:hover {
    transform: scale(1.05);
}
.lightbox {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.95);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

/* ✅ THIS IS THE KEY FIX */
.lightbox img {
    width: 80vw;        /* 80% of viewport width */
    height: 80vh;       /* 80% of viewport height */
    object-fit: contain;
    border-radius: 6px;
}

/* Close button */
.close-btn {
    position: absolute;
    top: 24px;
    right: 32px;
    font-size: 36px;
    color: #fff;
    cursor: pointer;
}

/* Navigation arrows */
.nav {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    font-size: 46px;
    color: #fff;
    cursor: pointer;
    user-select: none;
}

.prev { left: 40px; }
.next { right: 40px; }

/* RESPONSIVE */
@media (max-width: 992px) {
    .top-grid {
        grid-template-columns: 1fr;
    }

    .bottom-grid {
        grid-template-columns: repeat(3, 1fr);
    }
}

@media (max-width: 576px) {
    .bottom-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

</style>

{{-- ================= SCRIPT ================= --}}
<script>
    const images = document.querySelectorAll('.gallery-image');
    const lightbox = document.getElementById('lightbox');
    const lightboxImg = document.getElementById('lightbox-img');
    let currentIndex = 0;

    images.forEach(img => {
        img.addEventListener('click', () => {
            currentIndex = parseInt(img.dataset.index);
            openLightbox();
        });
    });

    function openLightbox() {
        lightbox.style.display = 'flex';
        lightboxImg.src = images[currentIndex].src;
    }

    function closeLightbox() {
        lightbox.style.display = 'none';
    }

    function changeSlide(step) {
        currentIndex += step;
        if (currentIndex < 0) currentIndex = images.length - 1;
        if (currentIndex >= images.length) currentIndex = 0;
        lightboxImg.src = images[currentIndex].src;
    }

    document.addEventListener('keydown', e => {
        if (e.key === 'Escape') closeLightbox();
        if (e.key === 'ArrowRight') changeSlide(1);
        if (e.key === 'ArrowLeft') changeSlide(-1);
    });
</script>
