@extends('layouts.app')

@section('title', 'Exhibitions')

@section('content')



<!-- ================= LISTING ================= -->
<section class="py-5 bg-white">
    <div class="site-inner">

      {{-- PAGE HEADING --}}
        <div class="text-center exhibition-heading">
            <h2>Exclusives</h2>
            <p>Explore our curated exhibition and event showcases.</p>
        </div>

        <div class="row g-4">
            @foreach($exhibitions as $exhibition)
            <div class="col-lg-4 col-md-6">
                <div class="exhibition-card">

                    <div class="exhibition-image">
                        <img src="{{ asset('storage/'.$exhibition->cover_image) }}">
                    </div>

                    <div class="exhibition-content">
                        <h3>{{ $exhibition->title }}</h3>

                        <div class="exhibition-footer">
                            <a href="{{ route('exhibitions.show', $exhibition->slug) }}"
                               class="know-more">
                                Know More
                            </a>

                            <div class="meta">
                                @if($exhibition->event_date)
                                <span>
                                    <i class="fa fa-calendar"></i>
                                    {{ \Carbon\Carbon::parse($exhibition->event_date)->format('F d, Y') }}
                                </span>
                                @endif

                                @if($exhibition->venue)
                                <span>
                                    <i class="fa fa-location-dot"></i>
                                    {{ $exhibition->venue }}
                                </span>
                                @endif
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            @endforeach
        </div>

    </div>
</section>

<!-- ================= SEO CONTENT ================= -->
@if(!empty($pageContents['exhibitions']->content))
<section class="seo-content">
    <div class="site-inner seo-text">
        {!! html_entity_decode($pageContents['exhibitions']->content) !!}
    </div>
</section>
@endif

@endsection
<style>

    /* ================= EXHIBITION HEADING ================= */
.exhibition-heading {
    margin-bottom: 40px;   /* heading → cards gap */
}

.exhibition-heading h2 {
    font-size: 30px;
    font-weight: 600;
    margin-bottom: 8px;
    color: #000;
}

.exhibition-heading p {
    font-size: 14px;
    color: #666;
    margin: 0;
}

/* MOBILE */
@media(max-width: 768px) {
    .exhibition-heading h2 {
        font-size: 24px;
    }
}

    /* ================= HERO ================= */
.page-hero {
    position: relative;
    height: 340px;
    overflow: hidden;
}

.page-hero img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.hero-overlay {
    position: absolute;
    inset: 0;
    background: rgba(0,0,0,0.25);
    display: flex;
    align-items: center;
    color: #fff;
}

.hero-overlay h1 {
    font-size: 38px;
    font-weight: 600;
}

.hero-overlay p {
    font-size: 14px;
    opacity: 0.9;
}

/* ================= CARD ================= */
.exhibition-card {
    background: #fff;
    border-radius: 12px;
    overflow: hidden;
    border: 1px solid #e6e6e6;
    transition: transform .3s ease, box-shadow .3s ease;
}

.exhibition-card:hover {
    transform: translateY(-6px);
    box-shadow: 0 12px 30px rgba(0,0,0,0.14);
}

/* ================= EXHIBITION CARD IMAGE – 16:9 ================= */

.exhibition-image {
    position: relative;
    width: 100%;
    aspect-ratio: 16 / 9;   /* ✅ 16:9 */
    overflow: hidden;
}


.exhibition-image img {
    position: absolute;
    inset: 0;

    width: 100%;
    height: 100%;
    object-fit: cover;   /* ✅ no stretch */
    transition: transform .6s ease;
}


.exhibition-card:hover img {
    transform: scale(1.08);
}

.exhibition-content {
    padding: 18px 20px 20px;
}

.exhibition-content h3 {
    font-size: 16px;
    font-weight: 600;
    line-height: 1.45;
    margin-bottom: 16px;
}

.exhibition-footer {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.know-more {
    font-size: 13px;
    font-weight: 600;
    color: #000;
    text-decoration: none;
}

.know-more:hover {
    text-decoration: underline;
}

.meta {
    font-size: 12px;
    color: #777;
    display: flex;
    gap: 14px;
}

.meta span {
    display: flex;
    align-items: center;
    gap: 6px;
}

.meta i {
    font-size: 12px;
    color: #999;
}

.meta span:last-child {
    max-width: 140px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

/* ================= MOBILE ================= */
@media(max-width: 768px) {
    .hero-overlay h1 {
        font-size: 28px;
    }

    .exhibition-footer {
        flex-direction: column;
        align-items: flex-start;
        gap: 6px;
    }
}

</style>