@extends('layouts.app')

@section('title', 'Exhibitions')

@section('content')

<!-- ================= HERO SECTION ================= -->
<section class="page-hero">
    <img src="{{ asset('uploads/about-banner.jpg') }}" alt="Exhibitions">

    <div class="hero-overlay">
        <h1>Exhibitions</h1>
        <p>Home \ Exhibitions</p>
    </div>
</section>

<!-- ================= EXHIBITIONS GRID ================= -->
<section class="py-5 bg-white">
    <div class="container">

        <div class="row g-4">

            <!-- CARD 1 -->
            <div class="col-lg-4 col-md-6">
                <div class="exhibition-card">
                    <div class="exhibition-image">
                        <img src="{{ asset('uploads/ex1.webp') }}" alt="">
                    </div>
                    <div class="exhibition-content">
                        <h3>Which Acrylic Paintings Are Perfect for Modern Interiors</h3>

                        <div class="exhibition-footer">
                            <a href="/exhibitions1" class="know-more">Know More</a>

                            <div class="meta">
                                <span>January 2, 2026</span>
                                <span>Uncategorized</span>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- CARD 2 -->
            <div class="col-lg-4 col-md-6">
                <div class="exhibition-card">
                    <div class="exhibition-image">
                        <img src="{{ asset('uploads/ex2.webp') }}" alt="">
                    </div>
                    <div class="exhibition-content">
                        <h3>Which Acrylic Paintings Are Perfect for Modern Interiors</h3>

                        <div class="exhibition-footer">
                            <a href="#" class="know-more">Know More</a>

                            <div class="meta">
                                <span>January 2, 2026</span>
                                <span>Uncategorized</span>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- CARD 3 -->
            <div class="col-lg-4 col-md-6">
                <div class="exhibition-card">
                    <div class="exhibition-image">
                        <img src="{{ asset('uploads/ex3.webp') }}" alt="">
                    </div>
                    <div class="exhibition-content">
                        <h3>Which Acrylic Paintings Are Perfect for Modern Interiors</h3>

                        <div class="exhibition-footer">
                            <a href="#" class="know-more">Know More</a>

                            <div class="meta">
                                <span>January 2, 2026</span>
                                <span>Uncategorized</span>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>

    </div>
</section>

<!-- ================= STYLES ================= -->
<style>
/* ================= HERO ================= */
.page-hero {
    position: relative;
    height: 340px;
    overflow: hidden;
}

.page-hero img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.hero-overlay {
    position: absolute;
    inset: 0;
    background: rgba(0,0,0,0.25);
    display: flex;
    flex-direction: column;
    justify-content: center;
    padding-left: 110px;
    color: #fff;
}

.hero-overlay h1 {
    font-size: 38px;
    font-weight: 600;
}

.hero-overlay p {
    font-size: 14px;
    opacity: 0.9;
}

/* ================= CARD ================= */
.exhibition-card {
    background: #fff;
    border-radius: 12px;
    overflow: hidden;
    border: 1px solid #e6e6e6;
    transition: transform .3s ease, box-shadow .3s ease;
}

.exhibition-card:hover {
    transform: translateY(-6px);
    box-shadow: 0 12px 30px rgba(0,0,0,0.14);
}

/* IMAGE */
.exhibition-image {
    height: 220px;
    overflow: hidden;
}

.exhibition-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform .6s ease;
}

.exhibition-card:hover img {
    transform: scale(1.08);
}

/* CONTENT */
.exhibition-content {
    padding: 18px 20px 20px;
}

.exhibition-content h3 {
    font-size: 16px;
    font-weight: 600;
    line-height: 1.45;
    margin-bottom: 16px;
}

/* FOOTER ROW (IMPORTANT FIX) */
.exhibition-footer {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

/* KNOW MORE */
.know-more {
    font-size: 13px;
    font-weight: 600;
    color: #000;
    text-decoration: none;
}

.know-more:hover {
    text-decoration: underline;
}

/* META (DATE + CATEGORY RIGHT SIDE) */
.meta {
    font-size: 12px;
    color: #777;
    display: flex;
    gap: 14px;
}

/* ================= RESPONSIVE ================= */
@media(max-width: 768px) {
    .hero-overlay {
        padding-left: 30px;
    }

    .hero-overlay h1 {
        font-size: 28px;
    }

    .exhibition-footer {
        flex-direction: column;
        align-items: flex-start;
        gap: 6px;
    }
}
</style>

@endsection
