@extends('layouts.app')

@section('title', $blog->seo_title ?? $blog->title)
@section('meta_description', $blog->meta_description ?? $blog->short_description)

@section('content')

<style>
body {
    font-family: 'Georgia', serif;
}

.blog-title {
    font-weight: 700;
    font-size: 2.4rem;
    text-align: center;
    line-height: 1.4;
    padding-bottom: 10px;
}

.blog-meta {
    text-align: center;
    font-size: 0.95rem;
    color: #6c757d;
    margin-bottom: 30px;
}

.blog-image {
    width: 100%;
    border-radius: 10px;
    margin-bottom: 30px;
    height: 23%;
}

.blog-content {
    font-size: 1.15rem;
    line-height: 1.9;
    color: #333;
}

.blog-content img {
    width: 100%;
    border-radius: 10px;
    margin: 20px 0;
}

.sidebar {
    background: #fff;
    border-radius: 12px;
    padding: 25px;
    box-shadow: 0px 4px 15px rgba(0,0,0,0.06);
    position: sticky;
    top: 90px;
}

.sidebar h4 {
    font-size: 1.3rem;
    margin-bottom: 20px;
    border-bottom: 2px solid #f1f1f1;
    padding-bottom: 10px;
    font-weight: 600;
}

.sidebar a {
    display: block;
    font-size: 0.95rem;
    margin-bottom: 12px;
    color: #000;
    text-decoration: none;
}

.sidebar a:hover {
    color: #ff6600;
    text-decoration: underline;
}

.share-buttons a {
    width: 44px;
    height: 44px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 0;
    border-radius: 50%;
    margin-right: 0;
    color: white;
    text-decoration: none;
}
.share-buttons {
    display: flex;
    justify-content: center;
    gap: 10px;
    flex-wrap: wrap;
    margin-bottom: 0;
}
.share-buttons svg{
    width: 18px;
    height: 18px;
    fill: #fff;
}

@media(max-width:768px){
    .blog-title { font-size:1.9rem; }
    .sidebar { margin-top:16px; }
    .blog-image{
        height:220px;
        object-fit:cover;
    }
}
</style>

<section class="py-5">
    <div class="site-inner">

        <a href="{{ \App\Models\SeoPage::url('blog', '/blogs') }}"
           class="btn btn-outline-dark rounded-pill px-4 mb-4">
            ← Back to Blogs
        </a>

        <h1 class="blog-title">{{ $blog->title }}</h1>

        <br>

        <div class="row gy-4">

            <!-- MAIN CONTENT -->
            <div class="col-lg-8">
                @if($blog->image)
                    <img src="{{ asset('uploads/blogs/'.$blog->image) }}"
                         alt="{{ $blog->title }}"
                         class="blog-image">
                @endif

                <div class="blog-content">
                    {!! $blog->content !!}
                </div>

                <!-- SHARE -->
                <hr class="my-5">

                <h5 class="text-center mb-3">Share This Article</h5>

                <div class="text-center share-buttons">
                    <a href="https://wa.me/?text={{ urlencode(url()->current()) }}"
                       target="_blank"
                       class="bg-success">
                        <svg viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M20 3.9A11.8 11.8 0 0 0 1.6 18.2L0 24l6-1.6A11.8 11.8 0 1 0 20 3.9Zm-8 18a9.7 9.7 0 0 1-4.9-1.3l-.4-.2-3.5.9.9-3.4-.2-.4a9.8 9.8 0 1 1 8.1 4.4Zm5.4-7.3c-.3-.2-1.7-.8-2-.9s-.5-.2-.7.2-.8.9-.9 1.1-.4.2-.7.1a8 8 0 0 1-2.4-1.5 8.8 8.8 0 0 1-1.6-2c-.2-.3 0-.5.1-.7l.5-.6c.1-.2.2-.3.3-.6s0-.4 0-.6l-.9-2.1c-.2-.5-.5-.4-.7-.4h-.6c-.2 0-.6.1-.9.4-.3.3-1.1 1.1-1.1 2.6s1.2 3 1.4 3.2 2.4 3.6 5.8 5a20 20 0 0 0 1.9.7c.8.3 1.5.2 2.1.1.6-.1 1.7-.7 1.9-1.4.2-.7.2-1.3.2-1.4s-.2-.2-.4-.3Z"/>
                        </svg>
                    </a>

                    <a href="https://www.facebook.com/sharer/sharer.php?u={{ url()->current() }}"
                       target="_blank"
                       class="bg-primary">
                        <svg viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M22 12a10 10 0 1 0-11.6 9.9v-7h-2.1V12h2.1V9.8c0-2.1 1.2-3.2 3.1-3.2.9 0 1.9.2 1.9.2V9h-1.1c-1.1 0-1.4.7-1.4 1.4V12h2.4l-.4 2.9h-2v7A10 10 0 0 0 22 12Z"/>
                        </svg>
                    </a>

                    <a href="https://twitter.com/intent/tweet?url={{ url()->current() }}&text={{ urlencode($blog->title) }}"
                       target="_blank"
                       class="bg-info">
                        <svg viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M18.9 2H22l-6.8 7.8L23 22h-6.1l-4.8-6.2L6.7 22H3.6l7.3-8.4L1.4 2h6.2l4.3 5.7L18.9 2Zm-1.1 18h1.7L6.7 3.9H4.9L17.8 20Z"/>
                        </svg>
                    </a>

                    <a href="https://www.linkedin.com/shareArticle?url={{ url()->current() }}"
                       target="_blank"
                       class="bg-secondary">
                        <svg viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M20.4 20.5h-3.6v-5.6c0-1.3 0-3-1.8-3s-2.1 1.5-2.1 2.9v5.7H9.3V9h3.4v1.6h.1c.5-.9 1.6-1.8 3.3-1.8 3.6 0 4.3 2.3 4.3 5.4v6.3ZM5.2 7.4a2.1 2.1 0 1 1 0-4.2 2.1 2.1 0 0 1 0 4.2Zm1.8 13.1H3.4V9H7v11.5Z"/>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- SIDEBAR -->
            <div class="col-lg-4">
                <div class="sidebar">
                    <h4>Recent Posts</h4>

                    @foreach($recentBlogs as $recent)
                        <a href="{{ route('blogs.show', $recent->slug) }}">
                            📝 {{ $recent->title }}<br>
                            <small class="text-muted">
                                {{ $recent->created_at->format('M d, Y') }}
                            </small>
                        </a>
                    @endforeach
                </div>
            </div>

        </div>

    </div>
</section>

@endsection
