@extends('artist.layouts.app')

@section('title','Edit Artwork')

@section('content')

<h4 class="fw-bold mb-4">Edit Artwork</h4>

<form action="{{ route('artist.paintings.update',$painting) }}"
      method="POST"
      enctype="multipart/form-data"
      class="card shadow-sm p-4">

@csrf
@method('PUT')

<input type="hidden" name="artist_id" value="{{ auth('artist')->id() }}">
<input type="hidden" name="artwork_type_id" value="{{ $painting->artwork_type_id }}">

{{-- CODE --}}
<div class="mb-3">
    <label>Artwork Code</label>
    <input type="text"
           name="painting_code"
           value="{{ $painting->painting_code }}"
           class="form-control">
</div>

{{-- TITLE --}}
<div class="mb-3">
    <label>Artwork Title</label>
    <input type="text"
           name="title"
           value="{{ $painting->title }}"
           required
           class="form-control">
</div>

{{-- UPDATED BY --}}
<div class="mb-3">
    <label>Updated By</label>
    <input type="text"
           name="updated_by"
           value="{{ $painting->updated_by }}"
           class="form-control">
</div>

{{-- THEMES --}}
<div class="mb-2">
    <label>Themes</label>
    <select id="categoryDropdown" class="form-select">
        <option value="">Select Theme</option>
        @foreach($categories as $id=>$name)
            <option value="{{ $id }}">{{ $name }}</option>
        @endforeach
    </select>
</div>

<div id="selectedCategories" class="d-flex flex-wrap gap-2 mb-2"></div>
<div id="hiddenCategoryInputs"></div>

<small class="text-muted d-block mb-3">
Multiple themes select करें, × से remove करें
</small>

{{-- MEDIUM --}}
<div class="mb-3">
    <label>Medium</label>
    <select name="medium_id" class="form-select">
        <option value="">Select Medium</option>
        @foreach($media as $id=>$name)
            <option value="{{ $id }}"
                {{ $painting->medium_id==$id?'selected':'' }}>
                {{ $name }}
            </option>
        @endforeach
    </select>
</div>

{{-- FORM --}}
<div class="mb-3">
    <label>Form</label>
    <select name="form_id" class="form-select">
        <option value="">Select Form</option>
        @foreach($forms as $id=>$name)
            <option value="{{ $id }}"
                {{ $painting->form_id==$id?'selected':'' }}>
                {{ $name }}
            </option>
        @endforeach
    </select>
</div>

{{-- DESCRIPTION --}}
<div class="mb-3">
    <label>Description</label>
    <textarea name="description"
              class="summernote">
{{ $painting->description }}
    </textarea>
</div>

{{-- PRICE --}}
<div class="mb-3">
    <label>Price</label>
    <input type="number"
           step="0.01"
           name="price"
           value="{{ $painting->price }}"
           class="form-control">
</div>

{{-- STATUS --}}
<div class="mb-3">
    <label>Availability</label>
    <select name="status" class="form-select">
        <option value="active"
         {{ $painting->status=='active'?'selected':'' }}>
         Available
        </option>

        <option value="sold"
         {{ $painting->status=='sold'?'selected':'' }}>
         Sold
        </option>

        <option value="inactive"
         {{ $painting->status=='inactive'?'selected':'' }}>
         Not Available
        </option>
    </select>
</div>

{{-- CURRENT IMAGE --}}
@if($painting->image)
<div class="mb-3">
    <label>Current Image</label><br>
    <img src="{{ asset('uploads/paintings/'.$painting->image) }}"
         style="width:150px;border-radius:8px;">
</div>
@endif

{{-- NEW IMAGE --}}
<div class="mb-3">
    <label>Change Image</label>
    <input type="file"
           name="image"
           accept="image/jpeg,image/png"
           class="form-control">
</div>

<button class="btn btn-dark px-4">
    Update Artwork
</button>

</form>

{{-- DELETE --}}
<form action="{{ route('artist.paintings.destroy',$painting) }}"
      method="POST"
      class="mt-3"
      onsubmit="return confirm('Delete permanently?')">

@csrf
@method('DELETE')

<button class="btn btn-danger px-4">
    Delete Artwork
</button>
</form>

@endsection

@push('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.css" rel="stylesheet">
@endpush

@push('scripts')

<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.js"></script>

<script>
$('.summernote').summernote({height:250});

// preload categories
@foreach($painting->categories as $cat)
addCategory({{ $cat->id }},"{{ $cat->name }}");
@endforeach

categoryDropdown.onchange=function(){
const id=this.value;
const text=this.options[this.selectedIndex].text;
if(!id || document.getElementById('chip-'+id)) return;
addCategory(id,text);
this.value='';
};

function addCategory(id,text){
const chip=document.createElement('span');
chip.id='chip-'+id;
chip.className='badge bg-secondary px-3 py-2';
chip.innerHTML=`${text} ×`;

const input=document.createElement('input');
input.type='hidden';
input.name='category_ids[]';
input.value=id;

chip.onclick=()=>{chip.remove();input.remove();};

selectedCategories.appendChild(chip);
hiddenCategoryInputs.appendChild(input);
}
</script>
@endpush
