@extends('admin.layout')

@section('content')

<div class="container-fluid">

    <div class="mb-4">
        <h4 class="fw-bold">Add Popular Search</h4>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            @foreach ($errors->all() as $error)
                <div>{{ $error }}</div>
            @endforeach
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">

            <form action="{{ route('admin.popular-searches.store') }}"
                  method="POST">
                @csrf

                <!-- TITLE -->
                <div class="mb-3">
                    <label class="form-label fw-semibold">Search Text</label>
                    <input type="text"
                           name="title"
                           class="form-control"
                           placeholder="e.g. Abstract Paintings"
                           value="{{ old('title') }}"
                           required>
                </div>

                <!-- LINK -->
                <div class="mb-3">
                    <label class="form-label fw-semibold">Link (URL)</label>
                    <input type="text"
                           name="link"
                           class="form-control"
                           placeholder="/paintings?style=abstract"
                           value="{{ old('link') }}"
                           required>
                </div>

                <!-- SORT ORDER -->
                <div class="mb-3">
                    <label class="form-label fw-semibold">Sort Order</label>
                    <input type="number"
                           name="sort_order"
                           class="form-control"
                           value="{{ old('sort_order', 0) }}">
                </div>

                <!-- STATUS -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Status</label>
                    <select name="status" class="form-select">
                        <option value="1" selected>Active</option>
                        <option value="0">Inactive</option>
                    </select>
                </div>

                <!-- SUBMIT -->
                <button type="submit" class="btn btn-success">
                    <i class="fa fa-save"></i> Save
                </button>

                <a href="{{ route('admin.popular-searches.index') }}"
                   class="btn btn-secondary ms-2">
                    Cancel
                </a>

            </form>

        </div>
    </div>

</div>

@endsection
