@extends('admin.layout')

@section('title', 'All Artworks')

@section('content')
<style>
.artwork-page .hero {
    background: linear-gradient(130deg, #fff8f2 0%, #ffe7d7 40%, #ffffff 100%);
    border: 1px solid #ffd6bc;
    border-radius: 18px;
    padding: 18px;
    box-shadow: 0 10px 25px rgba(230, 115, 44, 0.12);
}

.artwork-page .hero h2 {
    margin: 0;
    font-weight: 700;
}

.artwork-page .hero p {
    margin: 4px 0 0;
    color: #6b7280;
}

.artwork-page .add-btn {
    border-radius: 999px;
    font-weight: 600;
    padding: 10px 16px;
}

.artwork-page .hero-actions {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    justify-content: flex-end;
}

.artwork-page .stat-strip {
    display: grid;
    grid-template-columns: repeat(3, minmax(0, 1fr));
    gap: 12px;
}

.artwork-page .stat-card {
    background: #fff;
    border: 1px solid #ececec;
    border-radius: 14px;
    padding: 14px 16px;
    box-shadow: 0 6px 16px rgba(15, 23, 42, 0.05);
}

.artwork-page .stat-label {
    color: #6b7280;
    font-size: 13px;
}

.artwork-page .stat-value {
    font-weight: 700;
    font-size: 22px;
    line-height: 1.15;
    color: #1f2937;
}

.artwork-page .table-card {
    border-radius: 16px;
    overflow: hidden;
    border: 1px solid #ededed;
    box-shadow: 0 10px 24px rgba(15, 23, 42, 0.06);
}

.artwork-page .table thead th {
    font-size: 12px;
    letter-spacing: 0.4px;
    text-transform: uppercase;
    white-space: nowrap;
}

.artwork-page .table tbody td {
    vertical-align: middle;
}

.artwork-page .painting-thumb {
    width: 62px;
    height: 62px;
    object-fit: cover;
    border-radius: 10px;
    border: 1px solid #ececec;
}

.artwork-page .code-pill {
    background: #fff5eb;
    color: #c55c1c;
    border-radius: 999px;
    padding: 4px 10px;
    font-size: 12px;
    font-weight: 600;
    display: inline-block;
}

.artwork-page .title-main {
    font-weight: 600;
    color: #1f2937;
}

.artwork-page .meta-muted {
    color: #6b7280;
    font-size: 13px;
}

.artwork-page .btn-icon {
    height: 34px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    border-radius: 10px;
    padding: 0 12px;
}

.artwork-page .empty-box {
    padding: 36px 10px;
}

@media (max-width: 992px) {
    .artwork-page .stat-strip {
        grid-template-columns: 1fr;
    }

    .artwork-page .hero-actions {
        justify-content: flex-start;
    }
}
</style>

<div class="container py-4 artwork-page">

    <div class="hero d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-3 mb-4">
        <div>
            <h2>Artwork Management</h2>
            <p>Manage paintings, review details, and quickly edit records.</p>
        </div>

        <div class="hero-actions">
            <a href="{{ route('admin.paintings.bulk-upload') }}" class="btn btn-outline-dark add-btn">
                <i class="bi bi-cloud-upload me-1"></i> Bulk Upload
            </a>

            <a href="{{ route('admin.paintings.bulk-upload.template') }}" class="btn btn-outline-secondary add-btn">
                <i class="bi bi-download me-1"></i> Download Sample
            </a>

            <a href="{{ route('admin.paintings.create') }}" class="btn btn-warning text-white add-btn">
                <i class="bi bi-plus-circle me-1"></i> Add Artwork
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success shadow-sm border-0 rounded-4">
            {{ session('success') }}
        </div>
    @endif

    <div class="stat-strip mb-3">
        <div class="stat-card">
            <div class="stat-label">Total Artworks</div>
            <div class="stat-value">{{ number_format($paintings->total()) }}</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Visible On This Page</div>
            <div class="stat-value">{{ number_format($paintings->count()) }}</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Current Page</div>
            <div class="stat-value">{{ number_format($paintings->currentPage()) }}</div>
        </div>
    </div>

    <div class="card table-card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>S.No.</th>
                            <th>Code</th>
                            <th>Image</th>
                            <th>Artist</th>
                            <th>Form</th>
                            <th>Price</th>
                            <th>Updated By</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                    @forelse($paintings as $painting)
                        <tr>
                            <td>{{ $paintings->firstItem() + $loop->index }}</td>
                            <td><span class="code-pill">{{ $painting->painting_code ?? '--' }}</span></td>

                            <td>
                                @if($painting->image)
                                    <img src="{{ asset('uploads/paintings/'.$painting->image) }}" class="painting-thumb" alt="{{ $painting->title }}">
                                @else
                                    <span class="text-muted">No image</span>
                                @endif
                            </td>

                            <td>{{ $painting->artist->name ?? '--' }}</td>
                            <td>{{ $painting->form->name ?? '--' }}</td>
                            <td>
                                @if(!is_null($painting->price))
                                    <span class="fw-semibold text-success">&#8377; {{ (int) $painting->price }}</span>
                                @else
                                    <span class="text-muted">--</span>
                                @endif
                            </td>
                            <td>{{ $painting->updated_by ?? '--' }}</td>

                            <td class="text-center">
                                <div class="d-flex justify-content-center gap-2">
                                    <a href="{{ route('artworks.show', $painting->slug) }}" class="btn btn-sm btn-outline-secondary btn-icon">
                                        View
                                    </a>

                                    <a href="{{ route('admin.paintings.edit', $painting) }}" class="btn btn-sm btn-outline-primary btn-icon">
                                        Edit
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted empty-box">
                                <div class="fw-semibold mb-1">No artworks found.</div>
                                <div class="meta-muted">Add your first artwork to start building the catalog.</div>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="mt-3">
        {{ $paintings->links() }}
    </div>
</div>
@endsection
