﻿@extends('admin.layout')

@section('title', 'Edit Artwork')

@section('content')

<div class="painting-admin-page">
    <div class="paint-page-head mb-4">
        <p class="paint-kicker mb-1">Artwork Management</p>
        <h2 class="paint-title mb-1">Edit Artwork</h2>
        <p class="paint-subtitle mb-0">Refine artwork details with a cleaner premium control panel.</p>
    </div>

{{-- ================= UPDATE FORM ================= --}}
<form action="{{ route('admin.paintings.update', $painting) }}"
      method="POST"
      enctype="multipart/form-data"
      class="card shadow-sm p-4 painting-form-card border-0">

    @csrf
    @method('PUT')

    <input type="hidden" name="artwork_type_id" value="{{ $painting->artwork_type_id }}">

    <div class="mb-3">
        <label class="fw-semibold">Artwork Code</label>
        <input type="text" name="painting_code"
               value="{{ $painting->painting_code }}"
               class="form-control">
    </div>

    <div class="mb-3">
        <label class="fw-semibold">Artwork Title</label>
        <input type="text" name="title"
               value="{{ $painting->title }}"
               required
               class="form-control">
    </div>

    <div class="mb-3">
        <label class="fw-semibold">Updated By</label>
        <input type="text" name="updated_by"
               value="{{ $painting->updated_by }}"
               class="form-control">
    </div>

    <div class="mb-3">
        <label class="fw-semibold">Artist</label>
        <select name="artist_id" class="form-select">
            <option value="">Select Artist</option>
            @foreach($artists as $id => $name)
                <option value="{{ $id }}" {{ $painting->artist_id == $id ? 'selected' : '' }}>
                    {{ $name }}
                </option>
            @endforeach
        </select>
    </div>

    {{-- THEMES --}}
    <div class="mb-2">
        <label class="fw-semibold">Themes</label>
        <select id="categoryDropdown" class="form-select">
            <option value="">Select Theme</option>
            @foreach($categories as $id => $name)
                <option value="{{ $id }}">{{ $name }}</option>
            @endforeach
        </select>
    </div>

    <div id="selectedCategories" class="d-flex flex-wrap gap-2 mb-2"></div>
    <div id="hiddenCategoryInputs"></div>

    <small class="text-muted d-block mb-3">
        Multiple themes select à¤•à¤°à¥‡à¤‚, Ã— à¤¸à¥‡ remove à¤•à¤°à¥‡à¤‚
    </small>

   <div class="mb-3">
    <label class="fw-semibold">Medium</label>
    <select name="medium_id" id="mediumSelect" class="form-select">
        <option value="">Select Medium</option>
        @foreach($media as $medium)
            <option value="{{ $medium->id }}"
                    data-form-id="{{ $medium->form_id }}"
                    {{ $painting->medium_id == $medium->id ? 'selected' : '' }}>
                {{ $medium->name }}
            </option>
        @endforeach
    </select>
</div>


   <div class="mb-3">
    <label class="fw-semibold">Form</label>
    <select name="form_id" id="formSelect" class="form-select">
        <option value="">Select Form</option>
        @foreach($forms as $id => $name)
            <option value="{{ $id }}"
                {{ $painting->form_id == $id ? 'selected' : '' }}>
                {{ $name }}
            </option>
        @endforeach
    </select>
</div>


    <div class="mb-3">
        <label class="fw-semibold">Description</label>
        <textarea name="description" class="summernote">
{{ $painting->description }}
        </textarea>
    </div>

   {{-- PRICE --}}
<div class="mb-3">
    <label class="fw-semibold">Price</label>
    <input type="number"
           step="0.01"
           name="price"
           id="priceInput"
          value="{{ old('price', $painting->price) }}"

           class="form-control">
</div>

{{-- PRICE ON REQUEST --}}
<div class="form-check mb-4">
    <input class="form-check-input"
           type="checkbox"
           name="price_on_request"
           id="priceOnRequest"
           value="1"
         {{ old('price_on_request', $painting->price_on_request) ? 'checked' : '' }}>


    <label class="form-check-label fw-semibold" for="priceOnRequest">
        Price on Request
    </label>
</div>



    {{-- ARTWORK SIZE --}}
<div class="row mb-3">
    <div class="col-md-6">
        <label class="fw-semibold">Height</label>
        <input type="number"
               step="0.01"
               name="height"
              value="{{ old('height', $painting->height) }}"

               class="form-control"
               placeholder="Height (e.g. 24)">
    </div>

    <div class="col-md-6">
        <label class="fw-semibold">Width</label>
        <input type="number"
               step="0.01"
               name="width"
              value="{{ old('width', $painting->width) }}"

               class="form-control"
               placeholder="Width (e.g. 36)">
    </div>
</div>

<small class="text-muted d-block mb-3 painting-form-note">
    Example: Height Ã— Width (in inches or cm)
</small>


    <div class="mb-3">
        <label class="fw-semibold">Availability</label>
        <select name="status" class="form-select">
            <option value="active" {{ $painting->status == 'active' ? 'selected' : '' }}>Available</option>
            <option value="sold" {{ $painting->status == 'sold' ? 'selected' : '' }}>Sold</option>
            <option value="inactive" {{ $painting->status == 'inactive' ? 'selected' : '' }}>Not Available</option>
        </select>
    </div>

    @if($painting->image)
        <div class="mb-3">
            <label class="fw-semibold">Current Image</label><br>
            <img src="{{ asset('uploads/paintings/'.$painting->image) }}"
                 class="preview-artwork-image current-artwork-preview">
        </div>
    @endif

    <div class="mb-3">
        <label class="fw-semibold">Change Image</label>
        <input type="file" name="image"
               accept="image/jpeg,image/png"
               class="form-control">
    </div>

    <div class="d-flex gap-3 mt-4">
        <button type="submit" class="btn btn-primary px-4 painting-primary-btn">
            Update Artwork
        </button>
    </div>
</form>

{{-- ================= DELETE FORM (OUTSIDE) ================= --}}
<form action="{{ route('admin.paintings.destroy', $painting) }}"
      method="POST"
      class="mt-3 painting-delete-form"
      onsubmit="return confirm('Delete this artwork permanently?');">
    @csrf
    @method('DELETE')

    <button class="btn btn-danger px-4 painting-delete-btn">
        Delete Artwork
    </button>
</form>
</div>

@endsection


{{-- ================= STYLES & SCRIPTS ================= --}}

@push('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.css" rel="stylesheet">
<style>
.painting-admin-page {
    --paint-accent: #e6732c;
    --paint-accent-soft: #fff2e8;
    --paint-accent-dark: #c95e1f;
    --paint-text: #1b2433;
    --paint-muted: #6b7280;
    --paint-border: #d9deea;
}

.painting-admin-page .paint-page-head {
    padding: 1.2rem 1.4rem;
    border-radius: 18px;
    background: linear-gradient(145deg, #fff9f3 0%, #ffffff 52%, #fff4ea 100%);
    border: 1px solid #f4d7bf;
    box-shadow: 0 16px 34px rgba(16, 24, 40, 0.08);
}

.painting-admin-page .paint-kicker {
    letter-spacing: .11em;
    text-transform: uppercase;
    font-weight: 700;
    color: var(--paint-accent);
    font-size: .75rem;
}

.painting-admin-page .paint-title {
    color: var(--paint-text);
    font-size: 1.8rem;
    font-weight: 700;
}

.painting-admin-page .paint-subtitle {
    color: var(--paint-muted);
    font-size: .95rem;
}

.painting-admin-page .painting-form-card {
    position: relative;
    border-radius: 22px;
    background: linear-gradient(170deg, #ffffff 0%, #fff9f3 56%, #ffffff 100%);
    box-shadow: 0 28px 60px rgba(15, 23, 42, 0.12);
    overflow: hidden;
}

.painting-admin-page .painting-form-card::before {
    content: "";
    position: absolute;
    top: -160px;
    right: -80px;
    width: 340px;
    height: 340px;
    border-radius: 999px;
    background: radial-gradient(circle, rgba(230, 115, 44, 0.14) 0%, rgba(230, 115, 44, 0) 72%);
    pointer-events: none;
}

.painting-admin-page .painting-form-card > * {
    position: relative;
    z-index: 1;
}

.painting-admin-page .painting-form-card label.fw-semibold {
    display: block;
    margin-bottom: .45rem;
    font-size: .76rem;
    letter-spacing: .08em;
    text-transform: uppercase;
    color: #4b5a72;
}

.painting-admin-page .painting-form-card .form-control,
.painting-admin-page .painting-form-card .form-select {
    min-height: 46px;
    border-radius: 12px;
    border: 1px solid var(--paint-border);
    background: #ffffff;
    box-shadow: inset 0 1px 2px rgba(15, 23, 42, 0.05);
    transition: all .2s ease;
}

.painting-admin-page .painting-form-card .form-control[type="file"] {
    padding-top: .58rem;
    padding-bottom: .58rem;
}

.painting-admin-page .painting-form-card .form-control:focus,
.painting-admin-page .painting-form-card .form-select:focus {
    border-color: #ebb387;
    box-shadow: 0 0 0 .25rem rgba(230, 115, 44, 0.12);
}

.painting-admin-page .painting-form-card .input-group .btn {
    border-radius: 0 12px 12px 0;
    border-color: var(--paint-border);
}

.painting-admin-page .painting-form-card .form-check {
    border: 1px dashed #f2bf9d;
    background: var(--paint-accent-soft);
    border-radius: 12px;
    padding: .85rem 1rem .85rem 2.2rem;
}

.painting-admin-page .painting-form-card .form-check-input {
    margin-top: .28rem;
}

.painting-admin-page .painting-form-note {
    color: #7b8394 !important;
    font-size: .83rem;
}

.painting-admin-page #selectedCategories {
    min-height: 44px;
    border: 1px dashed #d6deed;
    border-radius: 12px;
    background: #fff;
    padding: .55rem .6rem;
}

.painting-admin-page #selectedCategories .badge {
    background: #fff3e8 !important;
    color: #8f4619 !important;
    border: 1px solid #f3c5a3;
    font-weight: 600;
}

.painting-admin-page .preview-artwork-image {
    width: 170px;
    margin-top: .8rem;
    border-radius: 12px;
    border: 1px solid #f0d9c8;
    box-shadow: 0 12px 24px rgba(15, 23, 42, 0.14);
}

.painting-admin-page .current-artwork-preview {
    display: block;
}

.painting-admin-page .painting-primary-btn {
    border: none;
    border-radius: 12px;
    background: linear-gradient(135deg, var(--paint-accent) 0%, #f19b52 100%);
    box-shadow: 0 14px 26px rgba(230, 115, 44, 0.28);
    font-weight: 600;
    letter-spacing: .02em;
}

.painting-admin-page .painting-primary-btn:hover {
    background: linear-gradient(135deg, var(--paint-accent-dark) 0%, var(--paint-accent) 100%);
    transform: translateY(-1px);
}

.painting-admin-page .painting-delete-form {
    padding: 1rem 1.1rem;
    border-radius: 14px;
    background: #fff;
    border: 1px solid #f1d5d5;
    box-shadow: 0 10px 24px rgba(120, 21, 21, 0.08);
}

.painting-admin-page .painting-delete-btn {
    border-radius: 10px;
    border: none;
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    box-shadow: 0 10px 20px rgba(220, 38, 38, 0.22);
}

.painting-admin-page .painting-delete-btn:hover {
    background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
}

.painting-admin-page .note-editor.note-frame {
    border: 1px solid var(--paint-border);
    border-radius: 12px;
    overflow: hidden;
}

.painting-admin-page .note-toolbar {
    background: #fff8f2;
    border-bottom: 1px solid #f1dac8;
}

.painting-admin-page .note-editing-area .note-editable {
    background: #fff;
}

.painting-admin-page .select2-container--default .select2-selection--single {
    height: 46px;
    border-radius: 12px;
    border: 1px solid var(--paint-border);
}

.painting-admin-page .select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 44px;
    padding-left: 12px;
}

.painting-admin-page .select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 44px;
    right: 8px;
}

@media (max-width: 768px) {
    .painting-admin-page .painting-form-card {
        padding: 1.25rem !important;
    }

    .painting-admin-page .paint-title {
        font-size: 1.45rem;
    }
}
</style>
@endpush

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.js"></script>
<script>
(function () {
    var $ = window.jQuery;
    function toDigits(value) {
        return String(value || '').replace(/\D/g, '');
    }

    function formatWithCommas(value) {
        return value ? value.replace(/\B(?=(\d{3})+(?!\d))/g, ',') : '';
    }

    function getPlainTextFromHtml(html) {
        var div = document.createElement('div');
        div.innerHTML = html || '';
        return (div.textContent || div.innerText || '').replace(/\u00a0/g, ' ');
    }

    function escapeHtml(text) {
        return $('<div>').text(text).html();
    }

    document.addEventListener('DOMContentLoaded', function () {
        var formEl = document.querySelector('form[action*="/admin/paintings/"][method="POST"]');

        var paintingCode = document.querySelector('input[name="painting_code"]');
        var initialPaintingCode = '';
        var artworkCodeWarningShown = false;

        function warnArtworkCodeChange() {
            if (!paintingCode || artworkCodeWarningShown) return;
            if (paintingCode.value !== initialPaintingCode) {
                alert('Changing Artwork Code will also change the artwork URL.');
                artworkCodeWarningShown = true;
            }
        }

        if (paintingCode) {
            paintingCode.setAttribute('maxlength', '10');
            paintingCode.addEventListener('input', function () {
                this.value = String(this.value || '')
                    .toUpperCase()
                    .replace(/[^A-Z0-9]/g, '')
                    .slice(0, 10);
            });
            paintingCode.value = String(paintingCode.value || '')
                .toUpperCase()
                .replace(/[^A-Z0-9]/g, '')
                .slice(0, 10);
            initialPaintingCode = paintingCode.value;
            paintingCode.addEventListener('change', warnArtworkCodeChange);
        }

        var artistSelect = document.querySelector('select[name="artist_id"]');
        if ($ && $.fn && $.fn.select2 && artistSelect) {
            $(artistSelect).select2({
                width: '100%',
                placeholder: 'Select Artist',
                allowClear: true
            });
        }

        var formSelect = document.getElementById('formSelect');
        var mediumSelect = document.getElementById('mediumSelect');

        function filterMediumByForm() {
            if (!formSelect || !mediumSelect) return;
            var selectedForm = formSelect.value;
            var hasValidMedium = false;

            Array.from(mediumSelect.options).forEach(function (option) {
                if (!option.value) {
                    option.hidden = false;
                    return;
                }

                var mediumForm = option.getAttribute('data-form-id');
                var isMatch = !selectedForm || mediumForm === selectedForm;
                option.hidden = !isMatch;

                if (!isMatch && option.selected) {
                    option.selected = false;
                }

                if (isMatch && option.selected) {
                    hasValidMedium = true;
                }
            });

            if (!hasValidMedium) {
                mediumSelect.value = '';
            }
        }

        if (formSelect && mediumSelect) {
            filterMediumByForm();
            formSelect.addEventListener('change', filterMediumByForm);
        }

        var descArea = document.querySelector('textarea[name="description"]');
        if ($ && descArea) {
            var $desc = $(descArea);
            if ($desc.next('.note-editor').length) {
                $desc.summernote('destroy');
            }

            function getDescriptionText() {
                return getPlainTextFromHtml($desc.summernote('code'));
            }

            function setDescriptionText(text) {
                $desc.summernote('code', escapeHtml(text).replace(/\n/g, '<br>'));
            }

            var syncing = false;
            $desc.summernote({
                height: 250,
                placeholder: 'Enter artwork description...',
                callbacks: {
                    onKeydown: function (e) {
                        var key = e.which || e.keyCode;
                        var ctrlOrCmd = e.ctrlKey || e.metaKey;
                        var allowedControl = [8, 9, 13, 27, 35, 36, 37, 38, 39, 40, 46].indexOf(key) !== -1;
                        if (ctrlOrCmd || allowedControl) return;

                        if (getDescriptionText().length >= 400) {
                            e.preventDefault();
                        }
                    },
                    onPaste: function (e) {
                        e.preventDefault();
                        var clipboard = (e.originalEvent || e).clipboardData || window.clipboardData;
                        var pasteText = clipboard ? (clipboard.getData('text') || '') : '';
                        var current = getDescriptionText();
                        var allowed = Math.max(0, 400 - current.length);
                        if (!allowed) return;
                        document.execCommand('insertText', false, pasteText.slice(0, allowed));
                    },
                    onChange: function () {
                        if (syncing) return;
                        var text = getDescriptionText();
                        if (text.length > 400) {
                            syncing = true;
                            setDescriptionText(text.slice(0, 400));
                            syncing = false;
                        }
                    }
                }
            });

            var initialText = getDescriptionText();
            if (initialText.length > 400) {
                setDescriptionText(initialText.slice(0, 400));
            }
        }

        var priceInput = document.getElementById('priceInput');
        var priceOnRequest = document.getElementById('priceOnRequest');
        var statusSelect = document.querySelector('select[name="status"]');

        if (priceInput) {
            priceInput.type = 'text';
            priceInput.setAttribute('inputmode', 'numeric');
        }

        function normalizePrice() {
            if (!priceInput) return;
            var digits = toDigits(priceInput.value).slice(0, 10);
            priceInput.value = formatWithCommas(digits);
        }

        function togglePriceField() {
            if (!priceInput) return;

            var statusValue = statusSelect ? statusSelect.value : '';

            if (statusValue === 'sold') {
                if (priceOnRequest) {
                    priceOnRequest.checked = true;
                    priceOnRequest.setAttribute('data-forced-by-status', '1');
                }
                priceInput.value = '';
                priceInput.setAttribute('disabled', 'disabled');
                return;
            }

            if (statusValue === 'active' && priceOnRequest && priceOnRequest.getAttribute('data-forced-by-status') === '1') {
                priceOnRequest.checked = false;
                priceOnRequest.removeAttribute('data-forced-by-status');
            }

            if (priceOnRequest && priceOnRequest.checked) {
                priceInput.value = '';
                priceInput.setAttribute('disabled', 'disabled');
            } else {
                priceInput.removeAttribute('disabled');
                normalizePrice();
            }
        }

        if (priceInput) {
            priceInput.addEventListener('input', normalizePrice);
            normalizePrice();
        }

        if (priceOnRequest) {
            priceOnRequest.addEventListener('change', function () {
                if (!priceOnRequest.checked) {
                    priceOnRequest.removeAttribute('data-forced-by-status');
                }
                togglePriceField();
            });
        }

        if (statusSelect) {
            statusSelect.addEventListener('change', togglePriceField);
        }

        togglePriceField();

        if (formEl && priceInput) {
            formEl.addEventListener('submit', function () {
                warnArtworkCodeChange();
                if (priceInput.disabled) return;
                priceInput.value = toDigits(priceInput.value).slice(0, 10);
            });
        }

        var sizeInputs = document.querySelectorAll('input[name="height"], input[name="width"]');
        sizeInputs.forEach(function (input) {
            input.type = 'text';
            input.setAttribute('inputmode', 'numeric');
            input.setAttribute('maxlength', '3');
            input.addEventListener('input', function () {
                this.value = toDigits(this.value).slice(0, 3);
            });
            input.value = toDigits(input.value).slice(0, 3);
        });

        var imageInput = document.getElementById('imageInput') || document.querySelector('input[name="image"]');
        if (imageInput) {
            if (!imageInput.id) imageInput.id = 'imageInput';
            var fileNameEl = document.getElementById('imageFileName');
            if (!fileNameEl) {
                fileNameEl = document.createElement('div');
                fileNameEl.id = 'imageFileName';
                fileNameEl.className = 'small text-muted mt-1';
                imageInput.insertAdjacentElement('afterend', fileNameEl);
            }

            function updateFileName() {
                var file = imageInput.files && imageInput.files[0];
                fileNameEl.textContent = file ? ('Selected file: ' + file.name) : '';
            }

            imageInput.addEventListener('change', updateFileName);
            updateFileName();
        }

        var dropdown = document.getElementById('categoryDropdown');
        var selectedBox = document.getElementById('selectedCategories');
        var hiddenInputs = document.getElementById('hiddenCategoryInputs');

        function addCategory(id, text) {
            if (!id || !selectedBox || !hiddenInputs) return;
            if (document.getElementById('chip-' + id)) return;

            var chip = document.createElement('span');
            chip.id = 'chip-' + id;
            chip.className = 'badge bg-light text-dark px-3 py-2';
            chip.innerHTML = text + '<span style="cursor:pointer;color:red;margin-left:6px;">×</span>';

            var input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'category_ids[]';
            input.value = id;
            input.id = 'input-' + id;

            chip.querySelector('span').onclick = function () {
                chip.remove();
                input.remove();
            };

            selectedBox.appendChild(chip);
            hiddenInputs.appendChild(input);
        }

        @foreach($painting->categories as $cat)
            addCategory('{{ $cat->id }}', @json($cat->name));
        @endforeach

        if (dropdown) {
            dropdown.addEventListener('change', function () {
                var id = this.value;
                var text = this.options[this.selectedIndex] ? this.options[this.selectedIndex].text : '';
                if (!id) return;
                addCategory(id, text);
                this.value = '';
            });
        }
    });
})();
</script>
@endpush

