@extends('admin.layout')

@section('content')
{{-- Categories module UI: Mediums tab requires form selection first. --}}
<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h3 class="mb-1">Categories</h3>
        <p class="text-muted mb-0">Manage Mediums under each Form.</p>
    </div>

    <button
        id="addMediumBtn"
        class="btn btn-warning text-white"
        data-bs-toggle="modal"
        data-bs-target="#createMediumModal"
        {{ empty($selectedFormId) ? 'disabled' : '' }}>
        Add New Medium
    </button>
</div>

<ul class="nav nav-tabs mb-3">
    <li class="nav-item">
        <a class="nav-link" href="{{ route('forms.index') }}">Forms</a>
    </li>
    <li class="nav-item">
        <a class="nav-link active" href="{{ route('mediums.index') }}">Mediums</a>
    </li>
</ul>

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

@if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
@endif

@if($errors->any())
    <div class="alert alert-danger">
        <strong>Please fix the following:</strong>
        <ul class="mb-0 mt-2">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

{{-- Select form + Go interaction (required by flow). --}}
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('mediums.index') }}" class="row g-2 align-items-end">
            <div class="col-md-5">
                <label class="form-label">Select Form</label>
                <select name="form_id" class="form-select" required>
                    <option value="">Select Form</option>
                    @foreach($forms as $form)
                        <option value="{{ $form->id }}" {{ (int) $selectedFormId === (int) $form->id ? 'selected' : '' }}>
                            {{ $form->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-auto">
                <button type="submit" class="btn btn-dark px-4">Go</button>
            </div>
        </form>
    </div>
</div>

@php
    $selectedForm = $forms->firstWhere('id', (int) $selectedFormId);
@endphp

@if(empty($selectedFormId))
    {{-- Default state before form selection. --}}
    <div class="card border-0 shadow-sm">
        <div class="card-body text-center py-5">
            <h5 class="mb-2">Select Form to Continue</h5>
            <p class="text-muted mb-0">Please choose a form from <strong>Select Form</strong> and click <strong>Go</strong> to view mediums.</p>
        </div>
    </div>
@elseif($mediums->isEmpty())
    {{-- Empty state after selecting a form with no mediums. --}}
    <div class="card border-0 shadow-sm">
        <div class="card-body text-center py-5">
            <h5 class="mb-2">No mediums found</h5>
            <p class="text-muted mb-0">
                No mediums available for <strong>{{ $selectedForm?->name ?? 'the selected form' }}</strong>. Click <strong>Add New Medium</strong> to create one.
            </p>
        </div>
    </div>
@else
    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th class="ps-3">Medium</th>
                            <th>Total Artworks</th>
                            <th>Updated By</th>
                            <th class="text-end pe-3" style="width: 170px;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($mediums as $medium)
                            <tr>
                                <td class="ps-3 fw-semibold">{{ $medium->name }}</td>
                                <td>{{ (int) $medium->paintings_count }}</td>
                                <td>{{ $medium->updated_by ?: '-' }}</td>
                                <td class="text-end pe-3">
                                    <button
                                        class="btn btn-sm btn-outline-primary"
                                        onclick='openEditMediumModal({{ $medium->id }}, {{ $medium->form_id }}, @json($medium->name), @json($medium->status))'>
                                        Edit
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endif

{{-- Add New Medium modal --}}
<div class="modal fade" id="createMediumModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="{{ route('mediums.store') }}">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Medium</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Select Form <span class="text-danger">*</span></label>
                        <select name="form_id" class="form-select" required>
                            <option value="">Select Form</option>
                            @foreach($forms as $form)
                                <option value="{{ $form->id }}" {{ (int) old('form_id', $selectedFormId) === (int) $form->id ? 'selected' : '' }}>
                                    {{ $form->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Medium Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" placeholder="Enter medium name" value="{{ old('name') }}" required>
                    </div>

                    <div class="mb-2">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="active" {{ old('status', 'active') === 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning text-white">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- Edit Medium modal (single reusable modal for cleaner UX). --}}
<div class="modal fade" id="editMediumModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="editMediumForm">
            @csrf
            @method('PUT')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Medium</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Select Form <span class="text-danger">*</span></label>
                        <select name="form_id" id="edit_form_id" class="form-select" required>
                            <option value="">Select Form</option>
                            @foreach($forms as $form)
                                <option value="{{ $form->id }}">{{ $form->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Medium Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="edit_medium_name" class="form-control" required>
                    </div>

                    <div>
                        <label class="form-label">Status</label>
                        <select name="status" id="edit_medium_status" class="form-select">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-danger me-auto" onclick="submitMediumDelete()">Delete</button>
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning text-white">Update</button>
                </div>
            </div>
        </form>

        <form method="POST" id="deleteMediumForm" style="display:none;">
            @csrf
            @method('DELETE')
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Keep Medium edit UX consistent with Form edit modal behavior.
function openEditMediumModal(id, formId, name, status) {
    document.getElementById('editMediumForm').action = `/admin/mediums/${id}`;
    document.getElementById('deleteMediumForm').action = `/admin/mediums/${id}`;
    document.getElementById('edit_form_id').value = String(formId);
    document.getElementById('edit_medium_name').value = name;
    document.getElementById('edit_medium_status').value = status;

    new bootstrap.Modal(document.getElementById('editMediumModal')).show();
}

function submitMediumDelete() {
    if (confirm('Delete this medium?')) {
        document.getElementById('deleteMediumForm').submit();
    }
}
</script>
@endpush
