@extends('admin.layout')

@section('content')
<style>
.media-admin-shell {
    --md-accent: #e6732c;
    --md-accent-dark: #cf5f1d;
    --md-border: #e8edf4;
    --md-text: #1f2937;
    --md-muted: #6b7280;
}

.md-hero {
    border-radius: 18px;
    border: 1px solid #f4d5bf;
    background: linear-gradient(130deg, #fff8f2 0%, #ffffff 58%, #fff1e6 100%);
    box-shadow: 0 16px 38px rgba(15, 23, 42, 0.08);
    padding: 18px 20px;
}

.md-kicker {
    margin: 0 0 4px;
    text-transform: uppercase;
    letter-spacing: .12em;
    font-size: .74rem;
    font-weight: 700;
    color: var(--md-accent);
}

.md-title {
    margin: 0;
    color: var(--md-text);
    font-weight: 700;
}

.md-subtitle {
    margin: 6px 0 0;
    color: var(--md-muted);
    font-size: .95rem;
}

.md-btn-primary {
    border: none;
    border-radius: 12px;
    background: linear-gradient(135deg, var(--md-accent) 0%, #f09552 100%);
    color: #fff;
    font-weight: 600;
    box-shadow: 0 14px 24px rgba(230, 115, 44, 0.22);
}

.md-btn-primary:hover {
    background: linear-gradient(135deg, var(--md-accent-dark) 0%, var(--md-accent) 100%);
    color: #fff;
}

.md-card {
    border-radius: 18px;
    border: 1px solid var(--md-border);
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.06);
    overflow: hidden;
    background: #fff;
}

.md-table { margin-bottom: 0; }

.md-table thead th {
    border-bottom: 1px solid #e9edf5;
    background: #f8fafc;
    color: #3a475a;
    font-size: .78rem;
    letter-spacing: .08em;
    text-transform: uppercase;
    font-weight: 700;
    white-space: nowrap;
}

.md-table tbody td {
    border-color: #f2f4f8;
    vertical-align: middle;
}

.md-thumb {
    width: 74px;
    height: 50px;
    border-radius: 10px;
    object-fit: cover;
    border: 1px solid #e5e7eb;
}

.md-status {
    display: inline-block;
    font-size: .74rem;
    font-weight: 700;
    border-radius: 999px;
    padding: 4px 9px;
}

.md-status.active { background: #dcfce7; color: #166534; }
.md-status.inactive { background: #eceff3; color: #475569; }

.md-empty {
    color: #6b7280;
    text-align: center;
    padding: 42px 12px;
}
</style>

<div class="media-admin-shell container-fluid py-4">
    <div class="md-hero mb-4 d-flex flex-column flex-lg-row align-items-lg-center justify-content-between gap-3">
        <div>
            <p class="md-kicker">Homepage Settings</p>
            <h2 class="md-title">Media Presence</h2>
            <p class="md-subtitle">Manage media logos/cards displayed on frontend.</p>
        </div>

        <a href="{{ route('admin.media.create') }}" class="btn md-btn-primary px-4">Add Media</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success border-0 shadow-sm">{{ session('success') }}</div>
    @endif

    <div class="md-card">
        <div class="table-responsive">
            <table class="table table-hover align-middle md-table">
                <thead>
                    <tr>
                        <th class="ps-3" width="90">S.NO.</th>
                        <th width="90">Image</th>
                        <th width="120">Order</th>
                        <th width="120">Status</th>
                        <th class="text-end pe-3" width="120">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $serialStart = method_exists($media, 'firstItem')
                            ? ($media->firstItem() ?? 1)
                            : 1;
                    @endphp
                    @forelse($media as $item)
                        <tr>
                            <td class="ps-3">
                                {{ $serialStart + $loop->index }}
                            </td>
                            <td>
                                <img src="{{ asset('storage/'.$item->image) }}" class="md-thumb" alt="Media image">
                            </td>
                            <td>{{ $item->sort_order }}</td>
                            <td>
                                <span class="md-status {{ $item->status ? 'active' : 'inactive' }}">
                                    {{ $item->status ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td class="text-end pe-3">
                                {{-- List action intentionally only Edit; delete is available on edit page. --}}
                                <a href="{{ route('admin.media.edit', $item->id) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="md-empty">No media found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
