@extends('admin.layout')

@section('content')
<style>
.md-form-shell {
    --md-accent: #e6732c;
    --md-accent-dark: #cf5f1d;
    --md-border: #e8edf4;
    --md-text: #1f2937;
}

.md-form-card {
    max-width: 760px;
    margin: 0 auto;
    border-radius: 18px;
    border: 1px solid var(--md-border);
    background: #fff;
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.08);
    overflow: hidden;
}

.md-form-head {
    padding: 16px 20px;
    background: linear-gradient(120deg, #fff8f2 0%, #fff 70%);
    border-bottom: 1px solid #edf1f7;
}

.md-form-head h2 {
    margin: 0;
    color: var(--md-text);
    font-size: 1.4rem;
    font-weight: 700;
}

.md-form-body {
    padding: 18px 20px;
}

.md-form-body label {
    font-size: .78rem;
    letter-spacing: .06em;
    text-transform: uppercase;
    font-weight: 700;
    color: #4b5a72;
    margin-bottom: .4rem;
}

.md-form-body .form-control,
.md-form-body .form-select {
    min-height: 44px;
    border-radius: 12px;
    border: 1px solid #d9e0eb;
}

.md-form-body .form-control:focus,
.md-form-body .form-select:focus {
    border-color: #ebb387;
    box-shadow: 0 0 0 .25rem rgba(230, 115, 44, 0.12);
}

.md-preview {
    width: 180px;
    height: 100px;
    object-fit: cover;
    border-radius: 12px;
    border: 1px solid #e5e7eb;
}

.md-btn-primary {
    border: none;
    border-radius: 12px;
    background: linear-gradient(135deg, var(--md-accent) 0%, #f09552 100%);
    color: #fff;
    font-weight: 600;
}

.md-btn-primary:hover {
    background: linear-gradient(135deg, var(--md-accent-dark) 0%, var(--md-accent) 100%);
    color: #fff;
}
</style>

<div class="md-form-shell container-fluid py-4">
    <div class="md-form-card">
        <div class="md-form-head d-flex justify-content-between align-items-center">
            <h2>Edit Media Presence</h2>
            <a href="{{ route('admin.media.index') }}" class="btn btn-light">Back</a>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger border-0 m-3 mb-0 shadow-sm">
                <strong>Please fix the following:</strong>
                <ul class="mb-0 mt-2">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('admin.media.update', $medium->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="md-form-body">
                <div class="mb-3">
                    <label>Current Image</label><br>
                    <img src="{{ asset('storage/'.$medium->image) }}" class="md-preview" alt="Current media image">
                </div>

                <div class="mb-3">
                    <label>Change Image</label>
                    <input type="file" name="image" class="form-control" accept="image/*">
                </div>

                <div class="mb-3">
                    <label>Sort Order</label>
                    <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order', $medium->sort_order) }}">
                </div>

                <div class="mb-4">
                    <label>Status</label>
                    <select name="status" class="form-select">
                        <option value="1" {{ $medium->status ? 'selected' : '' }}>Active</option>
                        <option value="0" {{ !$medium->status ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>

                <div class="d-flex justify-content-between gap-2 flex-wrap">
                    {{-- Delete is intentionally available only on edit page. --}}
                    <button type="button" class="btn btn-outline-danger" onclick="deleteMediaPresence()">Delete</button>

                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.media.index') }}" class="btn btn-light">Cancel</a>
                        <button type="submit" class="btn md-btn-primary px-4">Update</button>
                    </div>
                </div>
            </div>
        </form>

        <form id="deleteMediaForm" action="{{ route('admin.media.destroy', $medium->id) }}" method="POST" style="display:none;">
            @csrf
            @method('DELETE')
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
function deleteMediaPresence() {
    if (confirm('Delete this media?')) {
        document.getElementById('deleteMediaForm').submit();
    }
}
</script>
@endpush
