<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Admin Panel</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0" />

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.css" rel="stylesheet">
<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

<style>
:root {
    --accent: #e6732c;
    --accent-soft: #fff3e8;
    --bg-page: #f4f5f9;
    --bg-card: #ffffff;
    --text-main: #1f2937;
    --text-muted: #6b7280;
    --border: #e5e7eb;
}

body {
    margin: 0;
    background: radial-gradient(circle at top right, #fff6ef 0%, var(--bg-page) 28%, var(--bg-page) 100%);
    font-family: "Poppins", sans-serif;
    color: var(--text-main);
}

.modal {
    z-index: 99999 !important;
}

.modal-backdrop {
    z-index: 99998 !important;
}

.wrapper {
    display: flex;
    min-height: 100vh;
}

.sidebar {
    width: 250px;
    min-height: 100vh;
    height: 100vh;
    position: sticky;
    top: 0;
    overflow-y: auto;
    background: #0d1b2a;
    border-right: 1px solid var(--border);
    padding: 20px 15px;
    transition: all 0.3s ease;
    box-shadow: 8px 0 26px rgba(15, 23, 42, 0.05);
}

.sidebar.closed {
    width: 0;
    padding: 0;
    overflow: hidden;
}

.sidebar img.logo {
    width: 170px;
    margin-bottom: 25px;
}

.sidebar-title {
    font-size: 12px;
    font-weight: 600;
    color: #8c8c8c;
    margin-bottom: 8px;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.sidebar-menu a {
    display: flex;
    align-items: center;
    gap: 10px;
    color: var(--accent);
    font-size: 15px;
    padding: 10px;
    border-radius: 6px;
    text-decoration: none;
    margin-bottom: 5px;
    transition: 0.3s;
}

.sidebar-menu a:hover {
    background: var(--accent-soft);
    transform: translateX(5px);
}

.sidebar-menu a.active,
.page-toggle.active,
.pages-toggle.active {
    background: linear-gradient(135deg, #fff3e8 0%, #ffe0b2 100%);
    color: #1f2937;
    font-weight: 600;
}

.main-content {
    flex: 1;
    display: flex;
    flex-direction: column;
    min-width: 0;
}

.header {
    height: 70px;
    background: linear-gradient(105deg, #0b1522 0%, #102338 55%, #17314d 100%);
    border-bottom: 1px solid rgba(255,255,255,0.14);
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 20px;
    gap: 20px;
    position: sticky;
    top: 0;
    z-index: 1100;
    backdrop-filter: blur(8px);
}

.toggle-btn {
    background: rgba(255,255,255,0.12);
    color: #fff;
    padding: 10px 12px;
    border-radius: 12px;
    cursor: pointer;
    border: 1px solid rgba(255,255,255,0.2);
    transition: 0.3s;
}

.toggle-btn:hover {
    background: rgba(255,255,255,0.2);
}

.header-right {
    display: flex;
    align-items: center;
    gap: 20px;
}

.icon-btn {
    background: rgba(255,255,255,0.12);
    color: #fff;
    padding: 10px;
    border-radius: 12px;
    cursor: pointer;
    transition: 0.3s;
    border: 1px solid rgba(255,255,255,0.2);
}

.icon-btn:hover {
    background: rgba(255,255,255,0.2);
}

.profile-box {
    display: flex;
    align-items: center;
    gap: 10px;
    cursor: pointer;
    position: relative;
}

.profile-box img {
    width: 40px;
    height: 40px;
    border-radius: 50%;
}

.profile-name {
    font-size: 14px;
    font-weight: 600;
    color: #fff;
}

.profile-role {
    font-size: 12px;
    color: #dbeafe;
}

.dropdown,
.notification-dropdown {
    position: absolute;
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 6px 18px rgba(0, 0, 0, 0.2);
    display: none;
    overflow: hidden;
    z-index: 99999 !important;
}

.dropdown {
    right: 0;
    top: 55px;
    width: 170px;
}

.dropdown a {
    display: block;
    padding: 12px 15px;
    color: var(--text-main);
    font-size: 14px;
    text-decoration: none;
    border-bottom: 1px solid #eee;
}

.dropdown a:hover {
    background: #f7f7f7;
}

.page-content {
    padding: 16px;
    background: transparent;
    flex: 1;
    min-height: 0;
    overflow-y: auto;
}

.notification-dropdown {
    right: 0;
    top: 65px;
    width: 340px;
    max-height: 420px;
    overflow-y: auto;
    border: 1px solid #eceff5;
}

.notification-dropdown .notif-title {
    font-weight: 600;
    padding: 12px 15px;
    border-bottom: 1px solid #eee;
    display: flex;
    align-items: center;
    justify-content: space-between;
    position: sticky;
    top: 0;
    background: #fff;
    z-index: 2;
}

.notif-item {
    display: block;
    padding: 12px 15px;
    font-size: 14px;
    border-bottom: 1px solid #f2f2f2;
    cursor: pointer;
    text-decoration: none;
    color: #1f2937;
}

.notif-item:hover {
    background: #f8f8f8;
}

.notification-count {
    position: absolute;
    top: -4px;
    right: -4px;
    padding: 3px 6px;
    font-size: 10px;
    display: none;
}

body.dark-mode {
    background: #1e1e1e;
    color: white !important;
}

.dark-mode .header,
.dark-mode .sidebar,
.dark-mode .page-content {
    background: #2a2a2a !important;
    color: white !important;
}

.dark-mode .sidebar-menu a {
    color: #ffb36b !important;
}

.dark-mode .sidebar-menu a:hover {
    background: #3e3e3e !important;
}

.dark-mode .dropdown,
.dark-mode .notification-dropdown {
    background: #2a2a2a;
    color: white;
}

.dark-mode table {
    color: white;
}

.dark-mode .card {
    background: #2f2f2f !important;
}

.sidebar.collapsed {
    width: 75px;
    transition: 0.3s ease;
    padding: 20px 8px;
    overflow: hidden;
}

.sidebar.collapsed .sidebar-menu a span,
.sidebar.collapsed .sidebar-title,
.sidebar.collapsed .page-toggle span,
.sidebar.collapsed .pages-toggle span,
.sidebar.collapsed .page-container,
.sidebar.collapsed .pages-container {
    display: none !important;
}

.sidebar.collapsed .sidebar-menu a,
.sidebar.collapsed .page-toggle,
.sidebar.collapsed .pages-toggle {
    justify-content: center;
}

.sidebar.collapsed .logo {
    width: 50px;
    margin-left: 5px;
}

.modern-toggle {
    border-radius: 8px;
}

.search-container {
    position: relative;
    max-width: 430px;
    width: 100%;
}

.search-input {
    width: 100%;
    padding: 10px 40px;
    border-radius: 50px;
    border: 1px solid #ddd;
    background: #f4f4f4;
    font-size: 14px;
    transition: 0.3s;
}

.search-input:focus {
    background: #ffffff;
    border-color: var(--accent);
    box-shadow: 0 0 8px rgba(230, 115, 44, 0.4);
}

.search-icon {
    position: absolute;
    top: 11px;
    left: 15px;
    color: #666;
    font-size: 14px;
}

.search-suggestions {
    position: absolute;
    width: 100%;
    background: white;
    border-radius: 10px;
    border: 1px solid #eee;
    display: none;
    max-height: 200px;
    overflow-y: auto;
    z-index: 30;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

.search-suggestions p {
    padding: 10px;
    margin: 0;
    cursor: pointer;
}

.search-suggestions p:hover {
    background: #f4f4f4;
}

.animated-dropdown {
    transform-origin: top right;
    transform: scale(0.8);
    opacity: 0;
    transition: 0.2s ease;
}

.animated-dropdown.show {
    display: block !important;
    transform: scale(1);
    opacity: 1;
}

.modern-profile:hover {
    background: rgba(255,255,255,0.16);
    border-radius: 10px;
    padding: 5px 10px;
}

.search-input {
    background: rgba(255,255,255,0.95);
}

.notif-meta {
    display: block;
    font-size: 12px;
    color: #6b7280;
    margin-top: 3px;
}

.notif-empty {
    padding: 18px 15px;
    color: #6b7280;
    font-size: 13px;
    text-align: center;
}

.notif-all-link {
    font-size: 12px;
    text-decoration: none;
    color: var(--accent);
    font-weight: 600;
}

.page-toggle,
.pages-toggle {
    display: flex;
    align-items: center;
    gap: 10px;
    color: var(--accent);
    font-size: 15px;
    padding: 10px;
    border-radius: 6px;
    cursor: pointer;
    transition: 0.3s;
    margin-bottom: 5px;
    text-decoration: none;
}

.page-toggle:hover,
.pages-toggle:hover {
    background: linear-gradient(135deg, #fff3e8 0%, #ffe0b2 100%);
    transform: translateX(5px);
}

.page-toggle i.fa-chevron-down,
.pages-toggle i.fa-chevron-down {
    margin-left: auto;
    transition: transform 0.3s;
}

.page-toggle.rotated i.fa-chevron-down,
.pages-toggle.rotated i.fa-chevron-down {
    transform: rotate(180deg);
}

.page-container,
.pages-container {
    display: none;
    margin-left: 20px;
    margin-top: 6px;
    border-left: 2px solid var(--accent);
    padding-left: 10px;
}

.page-container.open,
.pages-container.open {
    display: block;
}

.page-container a,
.pages-container a {
    display: block;
    padding: 8px 10px;
    font-size: 13px;
    color: #666;
    text-decoration: none;
    border-radius: 5px;
    transition: 0.3s;
    margin-bottom: 3px;
}

.page-container a:hover,
.pages-container a:hover {
    background: #f0f0f0;
    color: #000;
    transform: translateX(3px);
}

.page-container a.active,
.pages-container a.active {
    background: #eaf2ff;
    color: #0b4db8;
    font-weight: 600;
}

.dark-mode .page-toggle,
.dark-mode .pages-toggle,
.dark-mode .page-container a,
.dark-mode .pages-container a {
    color: #eee;
}

.dark-mode .page-toggle:hover,
.dark-mode .pages-toggle:hover,
.dark-mode .page-container a:hover,
.dark-mode .pages-container a:hover {
    background: #3a3a3a;
}

@media (max-width: 992px) {
    .sidebar {
        width: 86px;
        padding: 16px 8px;
    }

    .sidebar .sidebar-title,
    .sidebar .sidebar-menu a span,
    .sidebar .page-toggle span,
    .sidebar .pages-toggle span,
    .sidebar .page-container,
    .sidebar .pages-container {
        display: none !important;
    }

    .sidebar .sidebar-menu a,
    .sidebar .page-toggle,
    .sidebar .pages-toggle {
        justify-content: center;
    }

    .search-container {
        max-width: 240px;
    }
}
</style>
@stack('styles')
</head>

<body>
@php
    // Header notifications are sourced from latest contact enquiries.
    $headerEnquiries = \App\Models\ContactEnquiry::query()
        ->latest()
        ->take(8)
        ->get(['id', 'name', 'subject', 'created_at']);
@endphp

<div class="wrapper">

@php
    $featuredArtistsRoute = request()->routeIs('admin.artists.featured');
    $artistsMenuActive = request()->routeIs('admin.artists.*') && !$featuredArtistsRoute;

    $homeMenuOpen = request()->routeIs(
        'admin.hero.*',
        'admin.categories.*',
        'admin.about-creativity.*',
        'admin.testimonials.*',
        'admin.media.*'
    ) || $featuredArtistsRoute;

    $blogMenuOpen = request()->routeIs('admin.blogs.*', 'admin.blog-categories.*');
    $contactMenuOpen = request()->routeIs('admin.contact.*');
    $footerMenuOpen = request()->routeIs('admin.footer.*', 'admin.popular-searches.*');
    $seoMenuOpen = request()->routeIs('admin.page-content.*', 'admin.seo-pages.*');
@endphp

<div class="sidebar" id="sidebar">
    <img src="{{ asset('uploads/users/artgallery.png') }}" class="logo" alt="Logo">

    <div class="sidebar-title">MAIN</div>

    <div class="sidebar-menu">
        <a href="{{ route('admin_dashboard') }}" class="{{ request()->routeIs('admin_dashboard') ? 'active' : '' }}">
            <i class="fa fa-gauge"></i> <span>Dashboard</span>
        </a>

        <a href="{{ route('forms.index') }}" class="{{ request()->routeIs('forms.*') ? 'active' : '' }}">
            <i class="fa fa-layer-group"></i>
            <span>Categories</span>
        </a>

        <div class="sidebar-title mt-3">PAGES</div>

        <a href="javascript:void(0)" onclick="toggleSection(this)" class="page-toggle {{ $homeMenuOpen ? 'active rotated is-route-open' : '' }}">
            <i class="fa fa-house"></i>
            <span>Home</span>
            <i class="fa fa-chevron-down ms-auto"></i>
        </a>
        <div class="page-container {{ $homeMenuOpen ? 'open' : '' }}">
            <a href="{{ route('admin.hero.index') }}" class="{{ request()->routeIs('admin.hero.*') ? 'active' : '' }}">Hero Section</a>
            <a href="{{ route('admin.artists.featured') }}" class="{{ $featuredArtistsRoute ? 'active' : '' }}">Meet Our Artists</a>
            <a href="{{ route('admin.categories.index') }}" class="{{ request()->routeIs('admin.categories.*') ? 'active' : '' }}">Art By Theme</a>
            <a href="{{ route('admin.about-creativity.index') }}" class="{{ request()->routeIs('admin.about-creativity.*') ? 'active' : '' }}">About Creativity</a>
            <a href="{{ route('admin.testimonials.index') }}" class="{{ request()->routeIs('admin.testimonials.*') ? 'active' : '' }}">Testimonials</a>
            <a href="{{ route('admin.media.index') }}" class="{{ request()->routeIs('admin.media.*') ? 'active' : '' }}">Media Presence</a>
        </div>

        <a href="{{ route('admin.about.edit') }}" class="{{ request()->routeIs('admin.about.*') ? 'active' : '' }}">
            <i class="fa fa-circle-info"></i>
            <span>About</span>
        </a>

        <a href="{{ route('admin.artists.index') }}" class="{{ $artistsMenuActive ? 'active' : '' }}">
            <i class="fa fa-user"></i>
            <span>Artists</span>
        </a>

        <a href="{{ route('admin.paintings.index') }}" class="{{ request()->routeIs('admin.paintings.*') ? 'active' : '' }}">
            <i class="fa fa-paintbrush"></i>
            <span>Artworks</span>
        </a>

        <a href="javascript:void(0)" onclick="toggleSection(this)" class="page-toggle {{ $blogMenuOpen ? 'active rotated is-route-open' : '' }}">
            <i class="fa fa-blog"></i>
            <span>Blog</span>
            <i class="fa fa-chevron-down ms-auto"></i>
        </a>
        <div class="page-container {{ $blogMenuOpen ? 'open' : '' }}">
            <a href="{{ route('admin.blogs.index') }}" class="{{ request()->routeIs('admin.blogs.*') ? 'active' : '' }}">Blogs</a>
            <a href="{{ route('admin.blog-categories.index') }}" class="{{ request()->routeIs('admin.blog-categories.*') ? 'active' : '' }}">Categories</a>
        </div>

        <a href="{{ route('admin.art-advisory.edit') }}" class="{{ request()->routeIs('admin.art-advisory.*') ? 'active' : '' }}">
            <i class="fa fa-paint-brush"></i>
            <span>Art Advisory</span>
        </a>

        <a href="javascript:void(0)" onclick="toggleSection(this)" class="page-toggle {{ $contactMenuOpen ? 'active rotated is-route-open' : '' }}">
            <i class="fa fa-envelope"></i>
            <span>Contact</span>
            <i class="fa fa-chevron-down ms-auto"></i>
        </a>
        <div class="page-container {{ $contactMenuOpen ? 'open' : '' }}">
            <a href="{{ route('admin.contact.settings') }}" class="{{ request()->routeIs('admin.contact.settings') || request()->routeIs('admin.contact.settings.update') ? 'active' : '' }}">Contact Page</a>
            <a href="{{ route('admin.contact.index') }}" class="{{ request()->routeIs('admin.contact.index') || request()->routeIs('admin.contact.show') || request()->routeIs('admin.contact.notifications.latest') ? 'active' : '' }}">Contact Enquiries</a>
        </div>

        <a href="javascript:void(0)" onclick="toggleSection(this)" class="page-toggle {{ $footerMenuOpen ? 'active rotated is-route-open' : '' }}">
            <i class="fa fa-shoe-prints"></i>
            <span>Footer (Frontend)</span>
            <i class="fa fa-chevron-down ms-auto"></i>
        </a>
        <div class="page-container {{ $footerMenuOpen ? 'open' : '' }}">
            <a href="{{ route('admin.footer.edit') }}" class="{{ request()->routeIs('admin.footer.*') ? 'active' : '' }}">Manage Footer</a>
            <a href="{{ route('admin.popular-searches.index') }}" class="{{ request()->routeIs('admin.popular-searches.*') ? 'active' : '' }}">Popular Searches</a>
        </div>

        <a href="{{ route('admin.exhibitions.index') }}" class="{{ request()->routeIs('admin.exhibitions.*') ? 'active' : '' }}">
            <i class="fa fa-calendar-days"></i> <span>Exclusive</span>
        </a>

        <div class="sidebar-title mt-3">SEO</div>
        <a href="javascript:void(0)" onclick="toggleSEO(this)" class="pages-toggle {{ $seoMenuOpen ? 'active rotated is-route-open' : '' }}">
            <i class="fa fa-search"></i>
            <span>SEO Pages</span>
            <i class="fa fa-chevron-down ms-auto"></i>
        </a>
        <div class="pages-container {{ $seoMenuOpen ? 'open' : '' }}" id="seoContainer">
            <!-- <a href="{{ route('admin.seo-pages.index') }}">Manage SEO Pages</a> -->
            <a href="{{ route('admin.page-content.edit', 'home') }}" class="{{ request()->routeIs('admin.page-content.edit') && request()->route('page') === 'home' ? 'active' : '' }}">Home Page SEO</a>
            <a href="{{ route('admin.page-content.edit', 'about') }}" class="{{ request()->routeIs('admin.page-content.edit') && request()->route('page') === 'about' ? 'active' : '' }}">About Page SEO</a>
            <a href="{{ route('admin.page-content.edit', 'exhibitions') }}" class="{{ request()->routeIs('admin.page-content.edit') && request()->route('page') === 'exhibitions' ? 'active' : '' }}">Exclusive Page SEO</a>
            <a href="{{ route('admin.page-content.edit', 'artworks') }}" class="{{ request()->routeIs('admin.page-content.edit') && request()->route('page') === 'artworks' ? 'active' : '' }}">Artworks Page SEO</a>
            <a href="{{ route('admin.page-content.edit', 'artists') }}" class="{{ request()->routeIs('admin.page-content.edit') && request()->route('page') === 'artists' ? 'active' : '' }}">Artists Page SEO</a>
            <a href="{{ route('admin.page-content.edit', 'contact') }}" class="{{ request()->routeIs('admin.page-content.edit') && request()->route('page') === 'contact' ? 'active' : '' }}">Contact Page SEO</a>
            <a href="{{ route('admin.page-content.edit', 'art-advisory') }}" class="{{ request()->routeIs('admin.page-content.edit') && request()->route('page') === 'art-advisory' ? 'active' : '' }}">Art Advisory Page SEO</a>
            <a href="{{ route('admin.page-content.edit', 'blogs') }}" class="{{ request()->routeIs('admin.page-content.edit') && request()->route('page') === 'blogs' ? 'active' : '' }}">Blog Listing Page SEO</a>
        </div>
    </div>
</div>

<div class="main-content">
    <div class="header shadow-sm">
        <button class="toggle-btn modern-toggle" onclick="toggleSidebar()">
            <i class="fa-solid fa-bars-staggered"></i>
        </button>

        <div class="search-container">
            <i class="fa fa-search search-icon"></i>
            <input type="text" id="globalSearch" class="search-input" placeholder="Search users, paintings, artists, categories...">
            <div class="search-suggestions" id="searchSuggestions"></div>
        </div>

        <div class="header-right">
            <div class="notif-wrap position-relative">
                <div class="icon-btn position-relative notif-btn" onclick="toggleNotification()">
                    <i class="fa-solid fa-bell"></i>
                    <span class="badge bg-danger notification-count" id="notificationCount">0</span>
                </div>

                <div class="notification-dropdown animated-dropdown" id="notificationDropdown">
                    <p class="notif-title mb-0">
                        <span>Enquiry Notifications</span>
                        <a href="{{ route('admin.contact.index') }}" class="notif-all-link">View All</a>
                    </p>

                    <div id="notificationList">
                        @forelse($headerEnquiries as $enquiry)
                            <a class="notif-item" data-enquiry-id="{{ $enquiry->id }}" href="{{ route('admin.contact.show', $enquiry->id) }}">
                                <i class="fa fa-comment-dots me-1 text-warning"></i>
                                New enquiry from <strong>{{ $enquiry->name }}</strong>
                                <span class="notif-meta">{{ \Illuminate\Support\Str::limit((string) $enquiry->subject, 40) }} • {{ $enquiry->created_at->diffForHumans() }}</span>
                            </a>
                        @empty
                            <div class="notif-empty">No enquiries yet.</div>
                        @endforelse
                    </div>
                </div>
            </div>

            <div class="profile-box modern-profile" onclick="toggleProfileMenu()">
                <img src="{{ asset('uploads/users/' . Auth::guard('admin')->user()->photo) }}" alt="Profile">

                <div>
                    <div class="profile-name">{{ Auth::guard('admin')->user()->name }}</div>
                    <div class="profile-role">Admin</div>
                </div>

                <div class="dropdown animated-dropdown" id="profileDropdown">
                    <a href="{{ route('admin_profile') }}"><i class="fa fa-user"></i> Profile</a>
                    <a href="{{ route('admin_logout') }}"><i class="fa fa-sign-out"></i> Logout</a>
                </div>
            </div>
        </div>
    </div>

    <div class="page-content">
        @yield('content')
    </div>
</div>

</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/ckeditor5/41.2.0/classic/ckeditor.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.js"></script>

<script>
function toggleSidebar() {
    document.getElementById("sidebar").classList.toggle("collapsed");
}

function toggleCategoryMenu(el) {
    const box = document.getElementById("categoryContainer");
    box.style.display = box.style.display === "block" ? "none" : "block";
    if (el) el.classList.toggle("rotated");
}

function toggleSEO(el) {
    if (el.classList.contains("is-route-open")) return;
    const box = document.getElementById("seoContainer");
    box.style.display = box.style.display === "block" ? "none" : "block";
    if (el) el.classList.toggle("rotated");
}

function toggleSection(el) {
    if (el.classList.contains("is-route-open")) return;
    const section = el.nextElementSibling;
    section.style.display = section.style.display === "block" ? "none" : "block";
    el.classList.toggle("rotated");
}

function toggleProfileMenu() {
    document.getElementById("profileDropdown").classList.toggle("show");
}

function toggleNotification() {
    const dropdown = document.getElementById("notificationDropdown");
    dropdown.classList.toggle("show");

    // Mark current enquiry notifications as seen on open.
    if (dropdown.classList.contains("show")) {
        markNotificationsSeen();
    }
}

document.getElementById("globalSearch").addEventListener("input", function () {
    const v = this.value.trim();
    const box = document.getElementById("searchSuggestions");

    if (v.length < 1) {
        box.style.display = "none";
        return;
    }

    box.innerHTML = `
        <p>Search "${v}" in Paintings</p>
        <p>Search "${v}" in Artists</p>
        <p>Search "${v}" in Categories</p>
        <p>Search "${v}" in Users</p>
    `;

    box.style.display = "block";
});

window.addEventListener("click", function (e) {
    if (!e.target.closest(".profile-box")) {
        document.getElementById("profileDropdown").classList.remove("show");
    }

    if (!e.target.closest(".notif-wrap")) {
        document.getElementById("notificationDropdown").classList.remove("show");
    }

    if (!e.target.closest(".search-container")) {
        document.getElementById("searchSuggestions").style.display = "none";
    }
});

function getCurrentMaxEnquiryId() {
    const items = document.querySelectorAll("#notificationList [data-enquiry-id]");
    let maxId = 0;
    items.forEach((node) => {
        const id = parseInt(node.getAttribute("data-enquiry-id") || "0", 10);
        if (id > maxId) maxId = id;
    });
    return maxId;
}

function getSeenEnquiryId() {
    return parseInt(localStorage.getItem("admin_seen_enquiry_id") || "0", 10);
}

function setSeenEnquiryId(id) {
    localStorage.setItem("admin_seen_enquiry_id", String(id));
}

function refreshNotificationBadge() {
    const countNode = document.getElementById("notificationCount");
    if (!countNode) return;

    const seenId = getSeenEnquiryId();
    const items = document.querySelectorAll("#notificationList [data-enquiry-id]");
    let unseen = 0;
    items.forEach((node) => {
        const id = parseInt(node.getAttribute("data-enquiry-id") || "0", 10);
        if (id > seenId) unseen++;
    });

    countNode.textContent = String(unseen);
    countNode.style.display = unseen > 0 ? "inline-block" : "none";
}

function markNotificationsSeen() {
    const maxId = getCurrentMaxEnquiryId();
    if (maxId > 0) {
        setSeenEnquiryId(maxId);
    }
    refreshNotificationBadge();
}

async function pullLatestEnquiryNotifications() {
    try {
        const url = "{{ route('admin.contact.notifications.latest') }}";
        const response = await fetch(url, { headers: { "X-Requested-With": "XMLHttpRequest" } });
        if (!response.ok) return;
        const data = await response.json();
        if (!data || !Array.isArray(data.items)) return;

        const list = document.getElementById("notificationList");
        if (!list) return;

        if (data.items.length === 0) {
            list.innerHTML = '<div class="notif-empty">No enquiries yet.</div>';
        } else {
            const esc = (value) => String(value ?? '')
                .replace(/&/g, '&amp;')
                .replace(/</g, '&lt;')
                .replace(/>/g, '&gt;')
                .replace(/"/g, '&quot;')
                .replace(/'/g, '&#039;');

            list.innerHTML = data.items.map((item) => `
                <a class="notif-item" data-enquiry-id="${item.id}" href="${item.url}">
                    <i class="fa fa-comment-dots me-1 text-warning"></i>
                    New enquiry from <strong>${esc(item.name)}</strong>
                    <span class="notif-meta">${esc(item.subject)} • ${esc(item.time)}</span>
                </a>
            `).join('');
        }

        refreshNotificationBadge();
    } catch (error) {
        // Keep header stable even if polling fails.
    }
}

function toggleTheme() {
    document.body.classList.toggle("dark-mode");

    const themeIcon = document.getElementById("themeIcon");
    if (!themeIcon) return;

    if (document.body.classList.contains("dark-mode")) {
        localStorage.setItem("theme", "dark");
        themeIcon.className = "fa-solid fa-sun";
    } else {
        localStorage.setItem("theme", "light");
        themeIcon.className = "fa-solid fa-moon";
    }
}

window.addEventListener("load", function () {
    const themeIcon = document.getElementById("themeIcon");
    if (!themeIcon) return;

    if (localStorage.getItem("theme") === "dark") {
        document.body.classList.add("dark-mode");
        themeIcon.className = "fa-solid fa-sun";
    } else {
        themeIcon.className = "fa-solid fa-moon";
    }

    // Initialize enquiry notification badge and poll for new enquiries.
    if (!localStorage.getItem("admin_seen_enquiry_id")) {
        const maxId = getCurrentMaxEnquiryId();
        if (maxId > 0) setSeenEnquiryId(maxId);
    }
    refreshNotificationBadge();
    setInterval(pullLatestEnquiryNotifications, 30000);
});
</script>

@stack('scripts')
@yield('scripts')

</body>
</html>
