@extends('admin.layout')

@section('content')

<div class="container-fluid">

    <h4 class="fw-bold mb-4">Footer Settings</h4>

    <form method="POST" action="{{ route('admin.footer.update') }}">
        @csrf

        <!-- FOOTER EXTRA CONTENT -->
        <div class="mb-4">
            <label class="form-label fw-semibold">
                Footer Extra Content (Shown Below Footer)
            </label>

            <textarea
                name="top_content"
                id="summernote"
                class="form-control"
            >{!! $footer->top_content ?? '' !!}</textarea>
        </div>

        <!-- ADDRESS -->
        <div class="mb-3">
            <label class="form-label fw-semibold">Address</label>
            <textarea
                name="address"
                class="form-control"
                rows="3"
            >{{ $footer->address ?? '' }}</textarea>
        </div>

        <!-- EMAIL -->
        <div class="mb-3">
            <label class="form-label fw-semibold">Email</label>
            <input
                type="email"
                name="email"
                class="form-control"
                value="{{ $footer->email ?? '' }}"
            >
        </div>

        <!-- PHONE -->
        <div class="mb-4">
            <label class="form-label fw-semibold">Phone</label>
            <input
                type="text"
                name="phone"
                class="form-control"
                value="{{ $footer->phone ?? '' }}"
            >
        </div>

        <button class="btn btn-success px-4">
            <i class="fa fa-save"></i> Save Footer
        </button>

    </form>

</div>

@endsection
@push('scripts')
<script>
$(document).ready(function () {
    $('#summernote').summernote({
        height: 220,
        placeholder: 'Write clean footer content…',
        toolbar: [
            ['style', ['bold', 'italic', 'underline']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['insert', ['link']],
            ['view', ['codeview']]
        ],
        callbacks: {
            onPaste: function (e) {
                let bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('Text');
                e.preventDefault();
                document.execCommand('insertText', false, bufferText);
            }
        }
    });
});
</script>

<style>
/* ================= SUMMERNOTE CLEAN FIX ================= */

/* Editor area */
.note-editor .note-editable {
    background: #ffffff !important;
    color: #000000 !important;
}

/* Remove unwanted background from pasted content */
.note-editor .note-editable * {
    background: transparent !important;
}

/* Lists spacing */
.note-editor .note-editable ul,
.note-editor .note-editable ol {
    padding-left: 20px;
}

/* Paragraph spacing */
.note-editor .note-editable p {
    margin-bottom: 10px;
}
</style>
@endpush
