@extends('admin.layout')

@section('content')
<style>
.exclusive-page .page-head {
    padding: 1.1rem 1.25rem;
    border-radius: 16px;
    border: 1px solid #f0d4bf;
    background: linear-gradient(140deg, #fff9f4 0%, #ffffff 68%, #fff3e8 100%);
    box-shadow: 0 14px 30px rgba(15, 23, 42, 0.08);
}

.exclusive-page .kicker {
    margin: 0 0 .2rem;
    font-size: .73rem;
    font-weight: 700;
    letter-spacing: .11em;
    text-transform: uppercase;
    color: #d97706;
}

.exclusive-page .title {
    margin: 0;
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
}

.exclusive-page .table-card {
    border: 1px solid #e6ebf3;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 20px 42px rgba(15, 23, 42, 0.08);
    background: #fff;
}

.exclusive-page .table-wrap {
    overflow-x: auto;
}

.exclusive-page table {
    width: 100%;
    min-width: 940px;
    border-collapse: collapse;
}

.exclusive-page thead th {
    background: #f5f8fd;
    color: #52607a;
    font-size: .74rem;
    text-transform: uppercase;
    letter-spacing: .06em;
    padding: .85rem 1rem;
    border-bottom: 1px solid #e7edf6;
}

.exclusive-page tbody td {
    padding: .9rem 1rem;
    border-bottom: 1px solid #edf1f7;
    vertical-align: middle;
    color: #1f2937;
}

.exclusive-page tbody tr:hover {
    background: #fbfdff;
}

.exclusive-page .btn-edit {
    border: 0;
    border-radius: 8px;
    padding: .38rem .72rem;
    font-size: .75rem;
    font-weight: 600;
    color: #fff;
    text-decoration: none;
    background: #2563eb;
}

.exclusive-page .btn-edit:hover {
    color: #fff;
    background: #1d4ed8;
}
</style>

<div class="exclusive-page">
    <div class="page-head mb-4 d-flex justify-content-between align-items-center gap-3">
        <div>
            <p class="kicker">Admin Panel</p>
            <h2 class="title">Exclusive Management</h2>
        </div>
        <a href="{{ route('admin.exhibitions.create') }}" class="btn btn-primary">
            <i class="fa fa-plus"></i> Add Exclusive
        </a>
    </div>

    <div class="table-card">
        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th style="width: 90px;">S.NO.</th>
                        <th>Title</th>
                        <th>Dates</th>
                        <th style="width: 120px;">Featured</th>
                        <th style="width: 120px;">Status</th>
                        <th style="width: 110px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($exhibitions as $exhibition)
                        @php
                            $today = \Carbon\Carbon::today();
                            $start = $exhibition->event_date
                                ? \Carbon\Carbon::parse($exhibition->event_date)
                                : null;
                            $end = $exhibition->end_date
                                ? \Carbon\Carbon::parse($exhibition->end_date)
                                : null;

                            if ($start && $end) {
                                if ($today->between($start, $end)) {
                                    $status = 'Ongoing';
                                    $badge = 'success';
                                } elseif ($today->lt($start)) {
                                    $status = 'Upcoming';
                                    $badge = 'info';
                                } else {
                                    $status = 'Past';
                                    $badge = 'secondary';
                                }
                            } elseif ($start) {
                                $status = $today->lt($start) ? 'Upcoming' : 'Past';
                                $badge = $today->lt($start) ? 'info' : 'secondary';
                            } else {
                                $status = '-';
                                $badge = 'dark';
                            }
                        @endphp

                        <tr>
                            <td>{{ $exhibitions->firstItem() + $loop->index }}</td>
                            <td>
                                <strong>{{ $exhibition->title }}</strong><br>
                                <small class="text-muted">{{ $exhibition->venue }}</small>
                            </td>
                            <td>
                                @if($exhibition->event_date)
                                    {{ \Carbon\Carbon::parse($exhibition->event_date)->format('d M Y') }}
                                @endif
                                @if($exhibition->end_date)
                                    <br>
                                    <small class="text-muted">to {{ \Carbon\Carbon::parse($exhibition->end_date)->format('d M Y') }}</small>
                                @endif
                            </td>
                            <td class="text-center">
                                @if($exhibition->is_featured)
                                    <span class="badge bg-warning text-dark">Featured</span>
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                <span class="badge bg-{{ $badge }}">{{ $status }}</span>
                            </td>
                            <td>
                                <a href="{{ route('admin.exhibitions.edit', $exhibition) }}" class="btn-edit">Edit</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">No exclusives found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-3">
        {{ $exhibitions->links('pagination::bootstrap-5') }}
    </div>
</div>
@endsection
