@extends('admin.layout')

@section('content')

<h2 class="mb-4">Add Exclusive</h2>

<form method="POST"
      action="{{ route('admin.exhibitions.store') }}"
      enctype="multipart/form-data">

    @csrf

    <!-- ================= BASIC DETAILS ================= -->

    <div class="mb-3">
        <label class="form-label">Title <span class="text-danger">*</span></label>
        <input type="text" name="title" class="form-control" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Venue</label>
        <input type="text" name="venue" class="form-control"
               placeholder="e.g. Hauz Khas Village, New Delhi">
    </div>

    <!-- ================= DATE & TIME ================= -->

    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Start Date</label>
            <input type="date" name="event_date" class="form-control">
        </div>

        <div class="col-md-6 mb-3">
            <label class="form-label">End Date</label>
            <input type="date" name="end_date" class="form-control">
        </div>
    </div>

    <div class="mb-3">
        <label class="form-label">Event Time</label>
        <input type="text" name="event_time"
               class="form-control"
               placeholder="e.g. 5:00 PM – 9:00 PM">
    </div>

    <!-- ================= META ================= -->

    <div class="mb-3">
        <label class="form-label">Category</label>
        <input type="text" name="category"
               class="form-control"
               placeholder="e.g. Painting, Sculpture, Mixed Media">
    </div>

    <div class="mb-3">
        <label class="form-label">Updated By (Admin Name)</label>
        <input type="text" name="updated_by"
               class="form-control"
               placeholder="e.g. Curated by Creativity Art Gallery">
    </div>

    <!-- ================= FEATURED ================= -->

    <div class="form-check mb-4">
        <input class="form-check-input"
               type="checkbox"
               name="is_featured"
               value="1"
               id="featuredCheck">
        <label class="form-check-label" for="featuredCheck">
            Mark as Featured Exclusive (Show on Home Page)
        </label>
    </div>

    <!-- ================= IMAGES ================= -->

    <div class="mb-3">
        <label class="form-label">Cover Image <span class="text-danger">*</span></label>
        <input type="file"
               name="cover_image"
               class="form-control"
               required>
        <small class="text-muted">Main thumbnail image (1200x800 px)</small>
    </div>

    <div class="mb-3">
        <label class="form-label">
            Gallery Images (Multiple Upload)
        </label>
        <input type="file"
               name="gallery[]"
               class="form-control"
               multiple>
        <small class="text-muted">
            You can select multiple images (recommended: 10–15 images) (1200x800 px)
        </small>
    </div>

    <!-- ================= DESCRIPTION ================= -->

    <div class="mb-4">
        <label class="form-label">Description</label>
        <textarea name="description"
                  class="form-control"
                  rows="5"
                  placeholder="Write exhibition details here..."></textarea>
    </div>

    <!-- ================= ACTION ================= -->

    <button class="btn btn-success px-4">
        Save Exclusive
    </button>

    <a href="{{ route('admin.exhibitions.index') }}"
       class="btn btn-secondary ms-2">
        Cancel
    </a>

</form>

@endsection
