<!-- resources/views/admin/contact/index.blade.php -->
@extends('admin.layout')

@section('content')
<style>
.contact-enquiry-page .page-head {
    padding: 1.1rem 1.25rem;
    border-radius: 16px;
    border: 1px solid #f0d4bf;
    background: linear-gradient(140deg, #fff9f4 0%, #ffffff 68%, #fff3e8 100%);
    box-shadow: 0 14px 30px rgba(15, 23, 42, 0.08);
}

.contact-enquiry-page .kicker {
    margin: 0 0 .2rem;
    font-size: .73rem;
    font-weight: 700;
    letter-spacing: .11em;
    text-transform: uppercase;
    color: #d97706;
}

.contact-enquiry-page .title {
    margin: 0;
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
}

.contact-enquiry-page .table-card {
    border: 1px solid #e6ebf3;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 20px 42px rgba(15, 23, 42, 0.08);
    background: #fff;
}

.contact-enquiry-page .table-wrap {
    overflow-x: auto;
}

.contact-enquiry-page table {
    width: 100%;
    min-width: 980px;
    border-collapse: collapse;
    table-layout: fixed;
}

.contact-enquiry-page thead th {
    background: #f5f8fd;
    color: #52607a;
    font-size: .74rem;
    text-transform: uppercase;
    letter-spacing: .06em;
    padding: .85rem 1rem;
    border-bottom: 1px solid #e7edf6;
}

.contact-enquiry-page tbody td {
    padding: .9rem 1rem;
    border-bottom: 1px solid #edf1f7;
    vertical-align: middle;
    color: #1f2937;
}

.contact-enquiry-page tbody tr:hover {
    background: #fbfdff;
}

.contact-enquiry-page .cell-email {
    word-break: break-word;
    white-space: normal;
}

.contact-enquiry-page .truncate-text {
    max-width: 100%;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    display: block;
}

.contact-enquiry-page .btn-view {
    border: 0;
    border-radius: 8px;
    padding: .36rem .7rem;
    font-size: .75rem;
    font-weight: 600;
    color: #fff;
    background: #2563eb;
    text-decoration: none;
}

.contact-enquiry-page .btn-view:hover {
    color: #fff;
    background: #1d4ed8;
}

.contact-enquiry-page .pagination-wrap {
    padding: .95rem 1.1rem 1.1rem;
}
</style>

<div class="contact-enquiry-page">
    <div class="page-head mb-4">
        <p class="kicker">Admin Panel</p>
        <h3 class="title">Contact Enquiries</h3>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="table-card">
        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th style="width: 70px;">S.No.</th>
                        <th style="width: 160px;">Name</th>
                        <th style="width: 240px;">Email</th>
                        <th style="width: 140px;">Phone</th>
                        <th>Subject</th>
                        <th>Message</th>
                        <th style="width: 130px;">Date</th>
                        <th style="width: 100px;">Action</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse($enquiries as $enquiry)
                    <tr>
                        <td>{{ $enquiries->firstItem() + $loop->index }}</td>
                        <td>{{ $enquiry->name }}</td>
                        <td class="cell-email">{{ $enquiry->email }}</td>
                        <td>{{ $enquiry->phone ?: '-' }}</td>
                        <td><span class="truncate-text" title="{{ $enquiry->subject }}">{{ $enquiry->subject ?: '-' }}</span></td>
                        <td><span class="truncate-text" title="{{ $enquiry->message }}">{{ $enquiry->message ?: '-' }}</span></td>
                        <td>{{ optional($enquiry->created_at)->format('d M Y') }}</td>
                        <td>
                            <a href="{{ route('admin.contact.show', $enquiry->id) }}" class="btn-view">View</a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">No enquiries found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="pagination-wrap d-flex justify-content-center">
            {{ $enquiries->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>

@endsection
