@extends('admin.layout')

@section('content')
<style>
.blog-index-page .page-head {
    padding: 1.15rem 1.3rem;
    border-radius: 16px;
    border: 1px solid #f0d4bf;
    background: linear-gradient(140deg, #fff9f4 0%, #ffffff 68%, #fff3e8 100%);
    box-shadow: 0 14px 30px rgba(15, 23, 42, 0.08);
}

.blog-index-page .kicker {
    margin: 0 0 .25rem;
    font-size: .74rem;
    font-weight: 700;
    letter-spacing: .12em;
    text-transform: uppercase;
    color: #d97706;
}

.blog-index-page .title {
    margin: 0;
    font-size: 1.65rem;
    font-weight: 700;
    color: #1f2937;
}

.blog-index-page .card-shell {
    border: 1px solid #e6ebf3;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 20px 42px rgba(15, 23, 42, 0.08);
}

.blog-index-page .card-head {
    padding: .95rem 1.1rem;
    background: #fbfcff;
    border-bottom: 1px solid #edf1f7;
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: .75rem;
}

.blog-index-page .add-btn {
    display: inline-flex;
    align-items: center;
    gap: .4rem;
    border: 0;
    border-radius: 10px;
    padding: .6rem .95rem;
    font-size: .85rem;
    font-weight: 600;
    color: #fff;
    background: linear-gradient(135deg, #e6732c 0%, #f59a4f 100%);
    text-decoration: none;
    box-shadow: 0 8px 18px rgba(230, 115, 44, 0.28);
}

.blog-index-page .add-btn:hover {
    color: #fff;
    background: linear-gradient(135deg, #ca5f1e 0%, #e6732c 100%);
}

.blog-index-page .table-wrap {
    overflow-x: auto;
}

.blog-index-page table {
    width: 100%;
    min-width: 860px;
    border-collapse: collapse;
}

.blog-index-page thead th {
    background: #f5f8fd;
    color: #52607a;
    font-size: .74rem;
    text-transform: uppercase;
    letter-spacing: .06em;
    padding: .85rem 1rem;
    border-bottom: 1px solid #e7edf6;
}

.blog-index-page tbody td {
    padding: .9rem 1rem;
    border-bottom: 1px solid #edf1f7;
    vertical-align: middle;
    color: #1f2937;
}

.blog-index-page tbody tr:hover {
    background: #fbfdff;
}

.blog-index-page .status-badge {
    display: inline-block;
    border-radius: 999px;
    padding: .28rem .62rem;
    font-size: .75rem;
    font-weight: 600;
}

.blog-index-page .status-published {
    background: #ecfdf3;
    color: #047857;
    border: 1px solid #9de4c2;
}

.blog-index-page .status-draft {
    background: #fff4e5;
    color: #b45309;
    border: 1px solid #f8d39b;
}

.blog-index-page .action-row {
    display: flex;
    gap: .45rem;
    flex-wrap: wrap;
}

.blog-index-page .btn-action {
    border: 0;
    border-radius: 8px;
    padding: .34rem .62rem;
    font-size: .74rem;
    font-weight: 600;
    text-decoration: none;
    color: #fff;
}

.blog-index-page .btn-edit {
    background: #2563eb;
}

.blog-index-page .btn-edit:hover {
    color: #fff;
    background: #1d4ed8;
}

.blog-index-page .empty-row {
    text-align: center;
    color: #6b7280;
}

.blog-index-page .pagination-wrap {
    padding: .95rem 1.1rem 1.1rem;
}

@media (max-width: 768px) {
    .blog-index-page .card-head {
        flex-direction: column;
        align-items: stretch;
    }

    .blog-index-page .add-btn {
        justify-content: center;
    }
}
</style>

<div class="blog-index-page">
    <div class="page-head mb-4">
        <p class="kicker">Admin Panel</p>
        <h2 class="title">Blog Management</h2>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card-shell bg-white">
        <div class="card-head">
            <strong style="color:#334155;">All Blogs</strong>
            <a href="{{ route('admin.blogs.create') }}" class="add-btn">+ Add New Blog</a>
        </div>

        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th>S.No.</th>
                        <th>Title</th>
                        <th>Status</th>
                        <th>Updated By</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($blogs as $blog)
                        <tr>
                            <td>{{ $blogs->firstItem() + $loop->index }}</td>
                            <td>{{ $blog->title }}</td>
                            <td>
                                @if($blog->status === 'published')
                                    <span class="status-badge status-published">Published</span>
                                @else
                                    <span class="status-badge status-draft">Draft</span>
                                @endif
                            </td>
                            <td>{{ $blog->updated_by ?? '-' }}</td>
                            <td>
                                <div class="action-row">
                                    <a href="{{ route('admin.blogs.edit', $blog) }}" class="btn-action btn-edit">Edit</a>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="empty-row">No blogs found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="pagination-wrap">
            {{ $blogs->links() }}
        </div>
    </div>
</div>
@endsection
