@extends('admin.layout')

@section('title', 'Artwork Types')

@section('content')
<div class="container py-4">

    <!-- HEADER -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold">Artwork Types</h2>

        <button class="btn btn-primary"
                data-bs-toggle="modal"
                data-bs-target="#createArtworkModal">
            <i class="fa fa-plus"></i> Add Artwork Type
        </button>
    </div>

    <!-- SUCCESS -->
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <!-- TABLE -->
    <div class="card shadow-sm">
        <div class="card-body p-0">

            <table class="table table-hover align-middle mb-0">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Image</th>
                        <th>Name</th>
                        <th>Status</th>
                        <th width="220">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($artworks as $artwork)
                    <tr>
                        <td>{{ $loop->iteration }}</td>

                        <td>
                            @if($artwork->image)
                                <img src="{{ asset('uploads/artworks/'.$artwork->image) }}"
                                     width="60"
                                     class="rounded border">
                            @else
                                <span class="text-muted">No Image</span>
                            @endif
                        </td>

                        <td class="fw-semibold">
                            {{ $artwork->name }}
                            <br>
                            <small class="text-muted">{{ $artwork->slug }}</small>
                        </td>

                        <td>
                            @if($artwork->status)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-danger">Inactive</span>
                            @endif
                        </td>

                        <td>
                            <div class="d-flex gap-2">

                                <!-- EDIT -->
                                <button class="btn btn-sm btn-info"
                                    data-bs-toggle="modal"
                                    data-bs-target="#editArtworkModal{{ $artwork->id }}">
                                    <i class="fa fa-edit"></i>
                                </button>

                                <!-- DELETE -->
                                <form action="{{ route('admin.artwork-types.destroy',$artwork) }}"
                                      method="POST"
                                      onsubmit="return confirm('Delete this artwork type?')">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>

                            </div>
                        </td>
                    </tr>

                    <!-- EDIT MODAL -->
                    <div class="modal fade" id="editArtworkModal{{ $artwork->id }}" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">

                                <form action="{{ route('admin.artwork-types.update',$artwork) }}"
                                      method="POST"
                                      enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')

                                    <div class="modal-header">
                                        <h5 class="modal-title">Edit Artwork Type</h5>
                                        <button class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">

                                        <label class="fw-semibold">Name</label>
                                        <input type="text"
                                               name="name"
                                               value="{{ $artwork->name }}"
                                               class="form-control mb-3"
                                               required>

                                        <label class="fw-semibold">Image</label>
                                        <input type="file"
                                               name="image"
                                               class="form-control mb-2">

                                        @if($artwork->image)
                                            <img src="{{ asset('uploads/artworks/'.$artwork->image) }}"
                                                 width="100"
                                                 class="border rounded mb-3">
                                        @endif

                                        <label class="fw-semibold">Status</label>
                                        <select name="status" class="form-select">
                                            <option value="1" {{ $artwork->status ? 'selected':'' }}>Active</option>
                                            <option value="0" {{ !$artwork->status ? 'selected':'' }}>Inactive</option>
                                        </select>

                                    </div>

                                    <div class="modal-footer">
                                        <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                        <button class="btn btn-primary">Update</button>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>

</div>


<!-- CREATE MODAL -->
<div class="modal fade" id="createArtworkModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">

            <form action="{{ route('admin.artwork-types.store') }}"
                  method="POST"
                  enctype="multipart/form-data">
                @csrf

                <div class="modal-header">
                    <h5 class="modal-title">Add Artwork Type</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <label class="fw-semibold">Name</label>
                    <input type="text"
                           name="name"
                           class="form-control mb-3"
                           required>

                    <label class="fw-semibold">Image</label>
                    <input type="file"
                           name="image"
                           class="form-control mb-3">

                    <label class="fw-semibold">Status</label>
                    <select name="status" class="form-select">
                        <option value="1">Active</option>
                        <option value="0">Inactive</option>
                    </select>

                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button class="btn btn-primary">Create</button>
                </div>

            </form>

        </div>
    </div>
</div>

@endsection
