@extends('admin.layout')

@section('content')

<style>
.artist-form-page {
    --artist-accent: #e6732c;
    --artist-accent-dark: #c95e1f;
    --artist-border: #dce3ef;
}

.artist-form-page .artist-head {
    padding: 1.1rem 1.3rem;
    border-radius: 16px;
    background: linear-gradient(140deg, #fff7ef 0%, #ffffff 58%, #fff3e8 100%);
    border: 1px solid #f3d6bf;
    box-shadow: 0 14px 28px rgba(15, 23, 42, 0.08);
}

.artist-form-page .kicker {
    margin: 0 0 .2rem;
    text-transform: uppercase;
    letter-spacing: .11em;
    font-size: .74rem;
    color: var(--artist-accent);
    font-weight: 700;
}

.artist-form-page .title {
    margin: 0;
    font-size: 1.7rem;
    font-weight: 700;
    color: #1f2937;
}

.artist-form-page .form-card {
    border-radius: 18px;
    border: 1px solid var(--artist-border);
    background: #fff;
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.08);
    overflow: hidden;
}

.artist-form-page .form-body {
    padding: 1.25rem;
}

.artist-form-page label {
    display: block;
    margin-bottom: .4rem;
    font-size: .77rem;
    text-transform: uppercase;
    letter-spacing: .07em;
    color: #526079;
    font-weight: 600;
}

.artist-form-page .form-control,
.artist-form-page textarea {
    width: 100%;
    padding: .62rem .72rem;
    border: 1px solid var(--artist-border);
    border-radius: 10px;
    background: #fff;
    margin-bottom: .9rem;
    transition: all .18s ease;
}

.artist-form-page textarea {
    min-height: 110px;
}

.artist-form-page .form-control:focus,
.artist-form-page textarea:focus {
    outline: none;
    border-color: #ebb488;
    box-shadow: 0 0 0 .2rem rgba(230,115,44,.12);
}

.artist-form-page .url-preview {
    background: #f8fafc;
    color: #475569;
}

.artist-form-page .feature-box {
    border: 1px dashed #f0c3a3;
    background: #fff6ef;
    border-radius: 10px;
    padding: .75rem .9rem;
    margin-bottom: 1rem;
}

.artist-form-page .feature-box small {
    color: #6b7280;
}

.artist-form-page .preview-box {
    display: inline-block;
    border: 1px solid #edf1f7;
    border-radius: 10px;
    padding: .55rem;
    background: #fff;
    margin-bottom: .85rem;
}

.artist-form-page .preview-box img {
    border-radius: 8px;
    object-fit: cover;
}

.artist-form-page .section-card {
    border-radius: 16px;
    border: 1px solid var(--artist-border);
    background: #fff;
    box-shadow: 0 18px 36px rgba(15, 23, 42, 0.07);
    padding: 1rem 1.1rem;
    margin-top: 1.2rem;
}

.artist-form-page .submit-btn {
    border: none;
    border-radius: 10px;
    padding: .64rem 1.15rem;
    background: linear-gradient(135deg, var(--artist-accent) 0%, #f1984c 100%);
    color: #fff;
    font-weight: 600;
    box-shadow: 0 10px 22px rgba(230,115,44,.28);
}

.artist-form-page .submit-btn:hover {
    background: linear-gradient(135deg, var(--artist-accent-dark) 0%, var(--artist-accent) 100%);
}

.artist-form-page .secondary-btn {
    border: none;
    border-radius: 10px;
    padding: .6rem 1rem;
    color: #fff;
    font-weight: 600;
    background: linear-gradient(135deg, #2563eb 0%, #4f83f2 100%);
}

.artist-form-page .paintings-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: .8rem;
}

.artist-form-page .paintings-table th,
.artist-form-page .paintings-table td {
    border-bottom: 1px solid #edf1f7;
    padding: .6rem .55rem;
}

.artist-form-page .paintings-table th {
    font-size: .75rem;
    text-transform: uppercase;
    letter-spacing: .06em;
    color: #5a6880;
    background: #f7f9fc;
}

.artist-form-page .action-row {
    display: flex;
    flex-wrap: wrap;
    gap: .55rem;
    margin-top: 1rem;
}

.artist-form-page .danger-btn {
    border: 0;
    border-radius: 10px;
    padding: .64rem 1rem;
    color: #fff;
    font-weight: 600;
    background: linear-gradient(135deg, #dc2626 0%, #ef4444 100%);
}

.artist-form-page .danger-btn:hover {
    background: linear-gradient(135deg, #b91c1c 0%, #dc2626 100%);
}

.artist-form-page .status-btn {
    border: 0;
    border-radius: 10px;
    padding: .64rem 1rem;
    color: #fff;
    font-weight: 600;
    background: linear-gradient(135deg, #4b5563 0%, #6b7280 100%);
}

.artist-form-page .status-btn:hover {
    background: linear-gradient(135deg, #374151 0%, #4b5563 100%);
}
</style>

<div class="artist-form-page">
    <div class="artist-head mb-4">
        <p class="kicker">Admin Panel</p>
        <h2 class="title">Edit Artist</h2>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if ($errors->any())
        <div class="alert alert-danger">
            @foreach ($errors->all() as $error)
                <div>{{ $error }}</div>
            @endforeach
        </div>
    @endif

    <div class="form-card">
        <form action="{{ route('admin.artists.update', $artist->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="form-body">
                <label>Name</label>
                <input type="text" name="name" id="artistNameInput" class="form-control" value="{{ old('name', $artist->name) }}" required>

                <label>Artist URL (Slug)</label>
                <input type="text" name="slug" id="artistSlugInput" class="form-control" value="{{ old('slug', $artist->slug) }}" placeholder="artist-slug">

                <label>Artist URL Preview</label>
                <input type="text" id="artistUrlPreview" class="form-control url-preview" readonly>

                <label>Updated By</label>
                <input type="text" name="updated_by" class="form-control" value="{{ old('updated_by', $artist->updated_by ?: optional(Auth::guard('admin')->user())->name) }}">

                <label>Email</label>
                <input type="email" name="email" class="form-control" value="{{ old('email', $artist->email) }}">

                <label>Username</label>
                <input type="text" name="username" class="form-control" value="{{ old('username', $artist->username) }}" required>

                <label>Phone</label>
                <input type="text" name="phone" class="form-control" value="{{ old('phone', $artist->phone) }}">

                <label>Bio</label>
                <textarea name="bio">{{ old('bio', $artist->bio) }}</textarea>

                <div class="feature-box">
                    <label style="display:flex;align-items:center;gap:8px;margin:0 0 .35rem 0;text-transform:none;letter-spacing:0;font-size:.9rem;color:#111827;">
                        <input type="checkbox" name="is_featured" value="1" {{ old('is_featured', $artist->is_featured) ? 'checked' : '' }}>
                        <strong>Featured Artist</strong>
                    </label>
                    <small>Featured artists appear on home and top of artist listing (Max 10).</small>
                </div>

                <label>Artwork Image (Top Artwork)</label>
                @if($artist->artwork_image)
                    <div class="preview-box">
                        <img src="{{ asset('uploads/artists/'.$artist->artwork_image) }}" width="180" alt="Artwork Image">
                    </div>
                @endif
                <input type="file" name="artwork_image" class="form-control">

                <label>Profile Image (Artist Portrait)</label>
                @if($artist->profile_image)
                    <div class="preview-box">
                        <img src="{{ asset('uploads/artists/'.$artist->profile_image) }}" width="120" height="120" alt="Profile Image" style="border-radius:50%;">
                    </div>
                @endif
                <input type="file" name="profile_image" class="form-control">

                <button type="submit" class="submit-btn">Update Artist</button>
            </div>
        </form>

        <div class="form-body pt-0">
            <div class="action-row">
                <form action="{{ route('admin.artists.toggleStatus', $artist) }}" method="POST">
                    @csrf
                    <button type="submit" class="status-btn">
                        {{ $artist->status === 'active' ? 'Block Artist' : 'Unblock Artist' }}
                    </button>
                </form>

                <form action="{{ route('admin.artists.destroy', $artist) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this artist?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="danger-btn">Delete Artist</button>
                </form>
            </div>
        </div>
    </div>

    <!-- <div class="section-card">
        <h3 style="margin:0 0 1rem 0;font-size:1.1rem;">Add New Painting</h3>

        <form action="{{ route('admin.artist.paintings.store', $artist->id) }}" method="POST" enctype="multipart/form-data">
            @csrf

            <label>Painting Title</label>
            <input type="text" name="title" class="form-control" required>

            <label>Painting Image</label>
            <input type="file" name="image" class="form-control" required>

            <label>Price (optional)</label>
            <input type="text" name="price" class="form-control">

            <label>Description (optional)</label>
            <textarea name="description"></textarea>

            <button type="submit" class="secondary-btn">Upload Painting</button>
        </form>
    </div>

    @if($artist->paintings->count())
    <div class="section-card">
        <h3 style="margin:0 0 .7rem 0;font-size:1.1rem;">Existing Paintings</h3>

        <table class="paintings-table">
            <thead>
                <tr>
                    <th>Image</th>
                    <th>Title</th>
                    <th>Price</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
            @foreach($artist->paintings as $painting)
                <tr>
                    <td>
                        <img src="{{ asset('uploads/paintings/'.$painting->image) }}" width="80" style="border-radius:8px;" alt="{{ $painting->title }}">
                    </td>
                    <td>{{ $painting->title }}</td>
                    <td>{{ $painting->price ?? '-' }}</td>
                    <td>{{ ucfirst($painting->status) }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    @endif
</div> -->

@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    var nameInput = document.getElementById('artistNameInput');
    var slugInput = document.getElementById('artistSlugInput');
    var previewInput = document.getElementById('artistUrlPreview');
    var baseUrl = '{{ url('/artist') }}/';
    var slugTouched = false;

    if (!nameInput || !slugInput || !previewInput) return;

    function slugify(value) {
        return String(value || '')
            .toLowerCase()
            .trim()
            .replace(/[^a-z0-9\s-]/g, '')
            .replace(/\s+/g, '-')
            .replace(/-+/g, '-')
            .replace(/^-|-$/g, '');
    }

    function refreshPreview() {
        var cleaned = slugify(slugInput.value);
        slugInput.value = cleaned;
        previewInput.value = baseUrl + cleaned;
    }

    slugInput.addEventListener('input', function () {
        slugTouched = true;
        refreshPreview();
    });

    nameInput.addEventListener('blur', function () {
        if (!slugTouched && !slugInput.value.trim()) {
            slugInput.value = slugify(nameInput.value);
        }
        refreshPreview();
    });

    refreshPreview();
});
</script>
@endpush
