@extends('admin.layout')

@section('title','Add Sculpture')

@section('content')
<div class="container-fluid">

    <div class="card shadow-sm">
        <div class="card-header bg-dark text-white">
            <h5 class="mb-0">➕ Add New Sculpture</h5>
        </div>

        <div class="card-body">

            @if($errors->any())
                <div class="alert alert-danger">
                    @foreach($errors->all() as $error)
                        <div>{{ $error }}</div>
                    @endforeach
                </div>
            @endif

            <form method="POST"
                  action="{{ route('admin.sculptures.store') }}"
                  enctype="multipart/form-data">
                @csrf

                <div class="row">

                    <!-- Title -->
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Title *</label>
                        <input type="text"
                               name="title"
                               class="form-control"
                               placeholder="Sculpture title"
                               value="{{ old('title') }}"
                               required>
                    </div>

                    <!-- Price -->
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Price *</label>
                        <input type="number"
                               name="price"
                               step="0.01"
                               class="form-control"
                               placeholder="Enter price"
                               value="{{ old('price') }}"
                               required>
                    </div>

                    <!-- Description -->
                    <div class="col-md-12 mb-3">
                        <label class="form-label fw-bold">Description</label>
                        <textarea name="description"
                                  rows="4"
                                  class="form-control"
                                  placeholder="Sculpture description">{{ old('description') }}</textarea>
                    </div>

                    <!-- Image -->
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">Image *</label>
                        <input type="file"
                               name="image"
                               class="form-control"
                               required>
                        <small class="text-muted">jpg, png, webp</small>
                    </div>

                </div>

                <div class="mt-4">
                    <button class="btn btn-success px-4">
                        Save Sculpture
                    </button>

                    <a href="{{ route('admin.sculptures.index') }}"
                       class="btn btn-secondary px-4">
                        Back
                    </a>
                </div>

            </form>

        </div>
    </div>

</div>
@endsection
