import { objectSpread2 as _objectSpread2 } from '../_virtual/_rollupPluginBabelHelpers.mjs';

function toUnderscoreCase(object, convertToUnderscoreCase = true) {
  if (object && Object.keys(object).length && convertToUnderscoreCase) {
    return Object.keys(object).map(key => ({
      [convertStringToUnderscoreCase(key)]: object[key]
    })).reduce((prev, next) => _objectSpread2(_objectSpread2({}, prev), next));
  }
  return object;
}
function convertStringToUnderscoreCase(camelCaseString) {
  return camelCaseString.split(/(?=[A-Z])/).join('_').toLowerCase();
}
function convertAllEventsToUnderscoreCase(monorailEvent) {
  return monorailEvent.events.map(event => {
    let convertToUnderscoreCase = true;
    let convertMetaToUnderscoreCase = true;
    if (event && event.options && Object.prototype.hasOwnProperty.call(event.options, 'convertEventCase')) {
      convertToUnderscoreCase = Boolean(event.options.convertEventCase);
    }
    if (event && event.options && Object.prototype.hasOwnProperty.call(event.options, 'convertMetaDataCase')) {
      convertMetaToUnderscoreCase = Boolean(event.options.convertMetaDataCase);
    }
    return _objectSpread2({
      /* eslint-disable @typescript-eslint/naming-convention */
      schema_id: event.schemaId,
      payload: toUnderscoreCase(event.payload, convertToUnderscoreCase)
    }, event.metadata && {
      metadata: toUnderscoreCase(event.metadata, convertMetaToUnderscoreCase)
    });
  });
}

export { convertAllEventsToUnderscoreCase, convertStringToUnderscoreCase, toUnderscoreCase };
