// Exporting these as objects instead of enums to improve chances of unused code being tree shaken.
const TrackingEvents = {
  TRACKING_ACCEPTED: "trackingConsentAccepted",
  TRACKING_DECLINED: "trackingConsentDeclined",
  MARKETING_ACCEPTED: "firstPartyMarketingConsentAccepted",
  SALE_OF_DATA_ACCEPTED: "thirdPartyMarketingConsentAccepted",
  ANALYTICS_ACCEPTED: "analyticsConsentAccepted",
  PREFERENCES_ACCEPTED: "preferencesConsentAccepted",
  MARKETING_DECLINED: "firstPartyMarketingConsentDeclined",
  SALE_OF_DATA_DECLINED: "thirdPartyMarketingConsentDeclined",
  ANALYTICS_DECLINED: "analyticsConsentDeclined",
  PREFERENCES_DECLINED: "preferencesConsentDeclined",
  CONSENT_COLLECTED: "visitorConsentCollected",
  CONSENT_TRACKING_API_LOADED: "consentTrackingApiLoaded"
};
const StorageVersionV2 = "2.1";
const StorageVersionV3 = "3";
const DisplayConsentValues = {
  ACCEPTED: "yes",
  DECLINED: "no",
  NO_INTERACTION: "no_interaction",
  NO_VALUE: ""
};
const ConsentValues = {
  NO_VALUE: "",
  ACCEPTED: "1",
  DECLINED: "0"
};
const DataProcessingPurpose = {
  PREFERENCES: "p",
  ANALYTICS: "a",
  MARKETING: "m",
  SALE_OF_DATA: "t"
};
const ConsentKeys = {
  MARKETING: "m",
  ANALYTICS: "a",
  PREFERENCES: "p",
  SALE_OF_DATA: "s"
};
const ConsentDisplayKeys = {
  MARKETING: "marketing",
  ANALYTICS: "analytics",
  PREFERENCES: "preferences",
  SALE_OF_DATA: "sale_of_data",
  EMAIL: "email"
};
const StorefrontApiConsentMetadata = {
  HEADLESS_STOREFRONT: "headlessStorefront",
  ROOT_DOMAIN: "rootDomain",
  CHECKOUT_ROOT_DOMAIN: "checkoutRootDomain",
  STOREFRONT_ROOT_DOMAIN: "storefrontRootDomain",
  STOREFRONT_ACCESS_TOKEN: "storefrontAccessToken",
  IS_EXTENSION_TOKEN: "isExtensionToken",
  METAFIELDS: "metafields"
}; // We don't allow to use /set_tracking_consent to ingest GPC consent. We assume it
 // First part is for fullfill, second part for reject.

export { ConsentDisplayKeys, ConsentKeys, ConsentValues, DataProcessingPurpose, DisplayConsentValues, StorageVersionV2, StorageVersionV3, StorefrontApiConsentMetadata, TrackingEvents };
