<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('exhibitions', function (Blueprint $table) {
            $table->string('venue')->nullable()->after('title');
            $table->string('event_time')->nullable()->after('event_date');
            $table->string('updated_by')->nullable()->after('status');
        });
    }

    public function down(): void
    {
        Schema::table('exhibitions', function (Blueprint $table) {
            $table->dropColumn(['venue', 'event_time', 'updated_by']);
        });
    }
};
