<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::create('forms', function (Blueprint $table) {
        $table->id();
        $table->string('name');            // Canvas, Paper, etc.
        $table->string('slug')->unique();
        $table->enum('status', ['active','inactive'])->default('active');
        $table->string('updated_by')->nullable();
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('forms');
    }
};
