<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up(): void
{
    Schema::create('about_creativity_sections', function (Blueprint $table) {
        $table->id();
        $table->string('title');
        $table->text('description_1');
        $table->text('description_2')->nullable();
        $table->string('media_type')->default('video'); // video | image
        $table->string('media_url')->nullable(); // youtube url OR image name
        $table->string('button_text')->nullable();
        $table->string('button_link')->nullable();
        $table->enum('status', ['active','inactive'])->default('active');
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
   public function down(): void
{
    Schema::dropIfExists('about_creativity_sections');
}

};
