<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Schema;
use Illuminate\Pagination\Paginator;

// MODELS
use App\Models\Form;
use App\Models\FooterSetting;
use App\Models\PopularSearch;
use App\Models\Testimonial;
use App\Models\MediaPresence;
use App\Models\PageContent;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        /* ===============================
         | PAGINATION BOOTSTRAP
         =============================== */
        Paginator::useBootstrapFive();

        /* ===============================
         | FORMS (HEADER MENU)
         | SAFE AGAINST MISSING / BROKEN TABLE
         =============================== */
        if (Schema::hasTable('forms')) {
            try {
                View::share(
                    'forms',
                    Form::where('status', 'active')
                        ->orderBy('name')
                        ->get()
                );
            } catch (\Throwable $e) {
                // table exists but engine / data broken
                View::share('forms', collect());
            }
        } else {
            View::share('forms', collect());
        }

        /* ===============================
         | FOOTER SETTINGS
         =============================== */
        if (Schema::hasTable('footer_settings')) {
            try {
                View::share(
                    'footerSetting',
                    FooterSetting::first()
                );
            } catch (\Throwable $e) {
                View::share('footerSetting', null);
            }
        }

        /* ===============================
         | POPULAR SEARCHES
         =============================== */
        if (Schema::hasTable('popular_searches')) {
            try {
                View::share(
                    'popularSearches',
                    PopularSearch::where('status', 1)
                        ->orderBy('sort_order')
                        ->get()
                );
            } catch (\Throwable $e) {
                View::share('popularSearches', collect());
            }
        } else {
            View::share('popularSearches', collect());
        }

        /* ===============================
         | TESTIMONIALS
         =============================== */
        if (Schema::hasTable('testimonials')) {
            try {
                View::share(
                    'testimonials',
                    Testimonial::where('status', 1)
                        ->orderBy('sort_order')
                        ->get()
                );
            } catch (\Throwable $e) {
                View::share('testimonials', collect());
            }
        } else {
            View::share('testimonials', collect());
        }

        /* ===============================
         | MEDIA PRESENCE
         =============================== */
        if (Schema::hasTable('media_presences')) {
            try {
                View::share(
                    'mediaPresences',
                    MediaPresence::where('status', 1)
                        ->orderBy('sort_order')
                        ->get()
                );
            } catch (\Throwable $e) {
                View::share('mediaPresences', collect());
            }
        } else {
            View::share('mediaPresences', collect());
        }

        /* ===============================
         | PAGE CONTENT (CMS / SEO)
         =============================== */
        if (Schema::hasTable('page_contents')) {
            try {
                View::share(
                    'pageContents',
                    PageContent::where('status', 1)
                        ->get()
                        ->keyBy('page_key')
                );
            } catch (\Throwable $e) {
                View::share('pageContents', collect());
            }
        } else {
            View::share('pageContents', collect());
        }
    }
}
