<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Medium;
use App\Models\Painting;

class Form extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'status',
        'updated_by',
    ];

    /**
     * A form can have multiple mediums
     */
    public function mediums()
    {
        return $this->hasMany(Medium::class);
    }

    /**
     * A form can have multiple paintings
     */
    public function paintings()
    {
        return $this->hasMany(Painting::class);
    }
}
