<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Blog extends Model
{
  protected $fillable = [
    'blog_category_id',
    'title',
    'slug',
    'short_description',
    'content',
    'status',
    'image',
    'seo_title',
    'meta_description',
];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($blog) {
            if (empty($blog->slug)) {
                $blog->slug = Str::slug($blog->title);
            }
        });
    }
}
