<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class ArtworkType extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'image',
        'status',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($artwork) {
            if (empty($artwork->slug)) {
                $artwork->slug = Str::slug($artwork->name);
            }
        });
    }

    public function paintings()
{
    return $this->hasMany(Painting::class, 'artwork_type_id');
}

}
