<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ContactEnquiry;
use Illuminate\Support\Facades\Mail;

class ArtworkEnquiryController extends Controller
{

public function artistEnquiry(Request $request)
{
    $data = $request->validate([
        'name'        => 'required|string|max:100',
        'email'       => 'required|email|max:255',
        'phone'       => 'nullable|string|max:20',
        'message'     => 'required|string|max:1000',
        'artist_name' => 'required|string|max:255',
    ]);

    $finalMessage =
        "Artist Enquiry\n\n" .
        "Artist: {$data['artist_name']}\n\n" .
        "Name: {$data['name']}\n" .
        "Email: {$data['email']}\n" .
        "Phone: " . ($data['phone'] ?? 'N/A') . "\n\n" .
        "Message:\n{$data['message']}";

    ContactEnquiry::create([
        'name'    => $data['name'],
        'email'   => $data['email'],
        'phone'   => $data['phone'],
        'subject' => 'Artist Enquiry - ' . $data['artist_name'],
        'message' => $finalMessage,
    ]);

    try {
        Mail::raw($finalMessage, function ($mail) use ($data) {
            $mail->to(config('mail.from.address'))
                 ->replyTo($data['email'])
                 ->subject('New Artist Enquiry');
        });
    } catch (\Exception $e) {}

    return response()->json([
        'success' => true,
        'message' => 'Thank you! Your enquiry has been sent successfully.'
    ]);
}

    public function store(Request $request)
    {
        /* =====================
         * VALIDATION
         * ===================== */
        $data = $request->validate([
            'name'           => 'required|string|max:100',
            'email'          => 'required|email|max:255',
            'phone'          => 'nullable|string|max:20',
            'message'        => 'required|string|max:1000',
            'painting_code'  => 'required|string|max:100',
            'painting_title' => 'required|string|max:255',
        ]);

        /* =====================
         * BUILD MESSAGE
         * ===================== */
        $emailMessage =
            "New Artwork Enquiry\n\n" .
            "Name: {$data['name']}\n" .
            "Email: {$data['email']}\n" .
            "Phone: " . ($data['phone'] ?? 'N/A') . "\n\n" .
            "Painting Code: {$data['painting_code']}\n" .
            "Painting Title: {$data['painting_title']}\n\n" .
            "Message:\n{$data['message']}\n\n" .
            "Source: Artwork Detail Page";

        /* =====================
         * SAVE TO DATABASE
         * ===================== */
        ContactEnquiry::create([
            'name'    => $data['name'],
            'email'   => $data['email'],
            'phone'   => $data['phone'],
            'subject' => 'Artwork Enquiry - ' . $data['painting_title'],
            'message' => $emailMessage,
        ]);

        /* =====================
         * EMAIL TO ADMIN
         * ===================== */
        try {
            Mail::raw($emailMessage, function ($mail) use ($data) {
                $mail->to(config('mail.from.address'))
                     ->replyTo($data['email'])
                     ->subject('New Artwork Enquiry');
            });
        } catch (\Exception $e) {
            // Mail fail ho jaye tab bhi enquiry DB me save rahe
        }

        /* =====================
         * AJAX RESPONSE
         * ===================== */
        return response()->json([
            'success' => true,
            'message' => 'Thank you! We have received your enquiry. Our team will contact you soon.'
        ]);
    }
}
