<?php

namespace App\Http\Controllers;
use App\Models\Favourite;
use Illuminate\Support\Facades\Auth;

use Illuminate\Http\Request;

class FavouriteController extends Controller
{
    //
    public function toggle($painting_id)
    {
        $user = Auth::user();

        $fav = Favourite::where('user_id',$user->id)
                        ->where('painting_id',$painting_id)
                        ->first();

        if($fav){
            $fav->delete();
            return back()->with('success','Removed from favourites');
        } else {
            Favourite::create([
                'user_id'=>$user->id,
                'painting_id'=>$painting_id
            ]);
            return back()->with('success','Added to favourites');
        }
    }

    public function myFavourites()
    {
        $favourites = Favourite::with('painting')
            ->where('user_id',Auth::id())
            ->get();

        return view('front.favourites', compact('favourites'));
    }
}
