<?php

namespace App\Http\Controllers\Artist;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Artist;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    /**
     * Show artist profile edit form
     */
    public function edit()
    {
        $artist = Artist::findOrFail(session('artist_id'));

        return view('artist.profile', compact('artist'));
    }

    /**
     * Update artist name (and email if needed)
     */
    public function update(Request $request)
    {
        $artist = Artist::findOrFail(session('artist_id'));

        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $artist->name = $request->name;
        $artist->save();

        return back()->with('success', 'Profile updated successfully');
    }

    /**
     * Show change password form
     */
    public function changePassword()
    {
        return view('artist.change-password');
    }

    /**
     * Update password
     */
    public function updatePassword(Request $request)
    {
        $artist = Artist::findOrFail(session('artist_id'));

        $request->validate([
            'current_password' => 'required',
            'password' => 'required|min:6|confirmed',
        ]);

        if (!Hash::check($request->current_password, $artist->password)) {
            return back()->withErrors([
                'current_password' => 'Current password is incorrect'
            ]);
        }

        $artist->password = Hash::make($request->password);
        $artist->save();

        return back()->with('success', 'Password updated successfully');
    }
}
