<?php

namespace App\Http\Controllers\Artist;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Painting;

class DashboardController extends Controller
{
    public function index()
    {
        $artist = Auth::guard('artist')->user();

        $paintings = Painting::where('artist_id', $artist->id)
            ->latest()
            ->get();

        return view('artist.dashboard', compact('artist', 'paintings'));
    }
}
