<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Sculpture;
use Illuminate\Http\Request;
use Str;

class SculptureController extends Controller
{
       public function index()
    {
        $sculptures = Sculpture::latest()->paginate(12);
        return view('admin.sculptures.index', compact('sculptures'));
    }

    public function create()
    {
        return view('admin.sculptures.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'price' => 'required|numeric',
            'image' => 'required|image|mimes:jpg,jpeg,png,webp'
        ]);

        $imageName = time().'.'.$request->image->extension();
        $request->image->move(public_path('uploads/sculptures'), $imageName);

        Sculpture::create([
            'title' => $request->title,
            'slug' => Str::slug($request->title),
            'description' => $request->description,
            'price' => $request->price,
            'image' => $imageName
        ]);

        return redirect()->route('admin.sculptures.index')
            ->with('success','Sculpture added successfully');
    }

    public function edit(Sculpture $sculpture)
    {
        return view('admin.sculptures.edit', compact('sculpture'));
    }

    public function update(Request $request, Sculpture $sculpture)
    {
        $request->validate([
            'title' => 'required',
            'price' => 'required|numeric',
            'image' => 'nullable|image|mimes:jpg,jpeg,png,webp'
        ]);

        if ($request->image) {
            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/sculptures'), $imageName);
            $sculpture->image = $imageName;
        }

        $sculpture->update([
            'title' => $request->title,
            'slug' => Str::slug($request->title),
            'description' => $request->description,
            'price' => $request->price
        ]);

        return redirect()->route('admin.sculptures.index')
            ->with('success','Sculpture updated successfully');
    }

    public function destroy(Sculpture $sculpture)
    {
        $sculpture->delete();
        return redirect()->back()->with('success','Sculpture deleted');
    }
}
