<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HeroSlide;
use Illuminate\Support\Facades\Auth;

class HeroSliderController extends Controller
{
    /* =========================
        INDEX
    ==========================*/
    public function index()
    {
        $sliders = HeroSlide::orderBy('sort_order', 'ASC')->get();
        return view('admin.hero.index', compact('sliders'));
    }

    /* =========================
        CREATE
    ==========================*/
    public function create()
    {
        return view('admin.hero.create');
    }

    /* =========================
        STORE
    ==========================*/
   public function store(Request $request)
{
    $request->validate([
        'title' => 'required',
        'image' => 'required|image',
    ]);

    $imageName = time().'.'.$request->image->extension();
    $request->image->move(public_path('uploads/hero'), $imageName);

    HeroSlide::create([
        'title' => $request->title,
        'subtitle' => $request->subtitle,
        'button_text' => $request->button_text,
        'button_link' => $request->button_link,
        'status' => $request->status,
        'sort_order' => $request->sort_order,
        'updated_by' => $request->updated_by, // ⭐ MANUAL
        'image' => $imageName,
    ]);

    return redirect()->route('admin.hero.index')
        ->with('success', 'Hero slide created successfully');
}

    /* =========================
        EDIT
    ==========================*/
    public function edit($id)
    {
        $slide = HeroSlide::findOrFail($id);
        return view('admin.hero.edit', compact('slide'));
    }

    /* =========================
        UPDATE
    ==========================*/
  public function update(Request $request, $id)
{
    $slide = HeroSlide::findOrFail($id);

    $data = $request->only([
        'title',
        'subtitle',
        'button_text',
        'button_link',
        'status',
        'sort_order',
        'updated_by', // ⭐ MANUAL
    ]);

    if ($request->hasFile('image')) {
        $imageName = time().'.'.$request->image->extension();
        $request->image->move(public_path('uploads/hero'), $imageName);
        $data['image'] = $imageName;
    }

    $slide->update($data);

    return redirect()->route('admin.hero.index')
        ->with('success', 'Hero slide updated successfully');
}

    /* =========================
        DELETE
    ==========================*/
    public function destroy($id)
    {
        $slide = HeroSlide::findOrFail($id);
        $slide->delete();

        return redirect()
            ->route('admin.hero.index')
            ->with('success', 'Hero slide deleted successfully');
    }
}
