<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FooterSetting;
use App\Models\PopularSearch;

class FooterController extends Controller
{
    public function edit()
    {
        $footer = FooterSetting::first();
        $searches = PopularSearch::orderBy('sort_order')->get();

        return view('admin.footer.edit', compact('footer', 'searches'));
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'top_content' => 'nullable',
            'address' => 'nullable',
            'email' => 'nullable|email',
            'phone' => 'nullable'
        ]);

        FooterSetting::updateOrCreate(['id' => 1], $data);

        return back()->with('success', 'Footer updated');
    }
}

