<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ExclusiveSection;

class ExclusiveSectionController extends Controller
{
    public function edit()
    {
        $exclusive = ExclusiveSection::first();
        return view('admin.exclusive.edit', compact('exclusive'));
    }

   public function update(Request $request)
{
    $data = $request->validate([
        'title'          => 'required|string|max:255',
        'subtitle'       => 'nullable|string|max:255',
        'heading'        => 'required|string|max:255',
        'description_1'  => 'required',
        'description_2'  => 'nullable',
        'button_text'    => 'nullable|string|max:255',
        'button_link'    => 'nullable|string|max:255',
        'image'          => 'nullable|image|max:2048',
        'status'         => 'required|in:active,inactive',
    ]);

    if ($request->hasFile('image')) {
        $imageName = time() . '.' . $request->image->extension();
        $request->image->move(public_path('uploads/exclusive'), $imageName);
        $data['image'] = $imageName;
    }

    $exclusive = ExclusiveSection::first();

    if (!$exclusive) {
        ExclusiveSection::create($data);
    } else {
        $exclusive->update($data);
    }

    return back()->with('success', 'Exclusive section updated successfully');
}
}