<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AboutSection;
use Illuminate\Http\Request;

class AboutSectionController extends Controller
{
    /**
     * Show edit page (ONLY ONE RECORD)
     */
    public function edit()
    {
        $about = AboutSection::firstOrFail();

        return view('admin.about.edit', compact('about'));
    }

    /**
     * Update About Page Content
     */
    public function update(Request $request)
    {
        $about = AboutSection::firstOrFail();

        $data = $request->validate([
            'page_title'            => 'required|string|max:255',
            'breadcrumb_text'       => 'nullable|string|max:255',

            'welcome_title'         => 'required|string|max:255',
            'welcome_subtitle'      => 'nullable|string|max:255',
            'welcome_description'   => 'nullable|string',

            'story_title'           => 'required|string|max:255',
            'story_description'     => 'nullable|string',

            'why_1_title'           => 'nullable|string|max:255',
            'why_1_desc'            => 'nullable|string',

            'why_2_title'           => 'nullable|string|max:255',
            'why_2_desc'            => 'nullable|string',

            'why_3_title'           => 'nullable|string|max:255',
            'why_3_desc'            => 'nullable|string',

            'commitment_title'      => 'nullable|string|max:255',
            'commitment_description'=> 'nullable|string',

            'cta_text'              => 'nullable|string|max:255',
            'cta_button_text'       => 'nullable|string|max:100',
            'cta_button_link'       => 'nullable|string|max:255',

            // IMAGES
            'banner_image'          => 'nullable|image|max:4096',
            'story_image'           => 'nullable|image|max:4096',
            'commitment_image'      => 'nullable|image|max:4096',
        ]);

        /* ---------- IMAGE UPLOADS ---------- */

        if ($request->hasFile('banner_image')) {
            if ($about->banner_image && file_exists(public_path('uploads/about/' . $about->banner_image))) {
                @unlink(public_path('uploads/about/' . $about->banner_image));
            }

            $filename = time() . '_banner.' . $request->banner_image->extension();
            $request->banner_image->move(public_path('uploads/about'), $filename);
            $data['banner_image'] = $filename;
        }

        if ($request->hasFile('story_image')) {
            if ($about->story_image && file_exists(public_path('uploads/about/' . $about->story_image))) {
                @unlink(public_path('uploads/about/' . $about->story_image));
            }

            $filename = time() . '_story.' . $request->story_image->extension();
            $request->story_image->move(public_path('uploads/about'), $filename);
            $data['story_image'] = $filename;
        }

        if ($request->hasFile('commitment_image')) {
            if ($about->commitment_image && file_exists(public_path('uploads/about/' . $about->commitment_image))) {
                @unlink(public_path('uploads/about/' . $about->commitment_image));
            }

            $filename = time() . '_commitment.' . $request->commitment_image->extension();
            $request->commitment_image->move(public_path('uploads/about'), $filename);
            $data['commitment_image'] = $filename;
        }

        $about->update($data);

        return back()->with('success', 'About page updated successfully!');
    }
}
