<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ArtistBulkErrorsExport implements FromCollection, WithHeadings
{
    public function __construct(protected array $errors)
    {
    }

    public function collection(): Collection
    {
        return collect($this->errors)->map(function (array $error) {
            return [
                'row' => $error['row'] ?? '',
                'name' => $error['name'] ?? '',
                'status' => $error['status'] ?? '',
                'email' => $error['email'] ?? '',
                'username' => $error['username'] ?? '',
                'reason' => $error['reason'] ?? 'Unknown error',
            ];
        });
    }

    public function headings(): array
    {
        return [
            'row',
            'name',
            'status',
            'email',
            'username',
            'reason',
        ];
    }
}
